% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc_Stochastic.R
\name{Stochastic}
\alias{Stochastic}
\title{c++ Stochastic class}
\arguments{
\item{InputType}{\code{Tick} or \code{ double }}

\item{n}{indicator period}

\item{nFast}{fast smooth}

\item{nSlow}{slow smooth}
}
\description{
c++ class documentation
}
\details{
R function \link{stochastic}.
}
\section{Usage}{
 \code{Stochastic< InputType >( int n, int nFast, int nSlow )}
}

\section{Public Members and Methods}{

\tabular{lll}{
\cr \strong{Name}                 \tab \strong{Return Type}        \tab \strong{Description}
\cr \code{Add( InputType value )} \tab \code{void}                 \tab update indicator
\cr \code{Reset()}                \tab \code{void}                 \tab reset to initial state
\cr \code{IsFormed()}             \tab \code{bool}                 \tab is indicator value valid?
\cr \code{GetValue()}             \tab \code{StochasticValue}      \tab has members \code{double kFast, dFast, dSlow}
\cr \code{GetKFastnHistory()}     \tab \code{std::vector< double >}\tab return k fast history
\cr \code{GetDFastHistory()}      \tab \code{std::vector< double >}\tab return d fast history
\cr \code{GetDSlowHistory()}      \tab \code{std::vector< double >}\tab return d slow history
\cr \code{GetHistory()}           \tab \code{DataFrame}            \tab return values history data.table with columns \code{k_fast, d_fast, d_slow}
}
}
\seealso{
Other c++ classes: \code{\link{BBands}},
  \code{\link{Candle}}, \code{\link{Cost}},
  \code{\link{Crossover}}, \code{\link{Ema}},
  \code{\link{Indicator}}, \code{\link{Order}},
  \code{\link{Processor}}, \code{\link{RollLinReg}},
  \code{\link{RollPercentRank}}, \code{\link{RollRange}},
  \code{\link{RollSd}}, \code{\link{RollVolumeProfile}},
  \code{\link{Rsi}}, \code{\link{Sma}}, \code{\link{Tick}}

Other c++ indicators: \code{\link{BBands}},
  \code{\link{Crossover}}, \code{\link{Ema}},
  \code{\link{Indicator}}, \code{\link{RollLinReg}},
  \code{\link{RollPercentRank}}, \code{\link{RollRange}},
  \code{\link{RollSd}}, \code{\link{RollVolumeProfile}},
  \code{\link{Rsi}}, \code{\link{Sma}}
}

