% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curvefunctions.R
\name{spot2forward}
\alias{spot2forward}
\title{Spot curve conversion}
\usage{
spot2forward(dates, spot, approximation = "constant")
}
\arguments{
\item{dates}{Term structure of rates.}

\item{spot}{Vector of spot rates to be converted.}

\item{approximation}{String that establish the approximation. Set
\code{'linear'} for a piecewise linear approximation, or \code{'constant'} for a
piecewise constant curve.}
}
\value{
Instantaneous forward curve based on the input spot and the input term
structure.
}
\description{
Uses a recursive method to calculate the instantaneous forward
rates of a given spot curve. Calculations and formulas based on the
definition of forward rates where \eqn{\exp{-rT} = \exp{-\int{f(t)dt}}}.
}
\details{
Requires continuous rates. Recommended that the input spot curve
starts with maturity 0, if not, input function will approximate zero node
as equal to node 1 (first term structure). The time partition and available
data affects calculation and precision of resulting forward curve. Output
forward curve slightly differs from empirical curve as it calculates an
implied instantaneous forward curve.
}
\examples{
# Inputs for calibration of spot curve
yield.curve <- c(0.015,0.0175, 0.0225, 0.0275, 0.0325, 0.0375,0.04,0.0425,0.045,0.0475,0.05)
names(yield.curve) <- c(0.5,1,2,3,4,5,6,7,8,9,10)
nodes <- seq(0,10,0.001)
# Calibration
spot <- curve.calibration (yield.curve = yield.curve, market.assets = NULL,
                           analysis.date = "2019-01-03", asset.type = "IBRSwaps",
                           freq = 4, rate.type = 0, fwd = 0, npieces = NULL,
                           obj = "Price", nodes = nodes, approximation = "linear")
# Spot to Forward
dates <- names(spot)
spot2forward(dates, spot, approximation = "linear")

}
