% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Quandlpointintime.R
\name{Quandl.pit.between}
\alias{Quandl.pit.between}
\title{Retrieves Point In Time Data from the Quandl PIT endpoint.
Between start and end will show all rows that were visible at any point between two specified points in time. It works inclusively, a row visible exactly at start or exactly at end will be shown too.}
\usage{
Quandl.pit.between(datatable_code, start_date, end_date, paginate = FALSE, ...)
}
\arguments{
\item{datatable_code}{Datatable code on Quandl specified as a string.}

\item{start_date}{Lower date as a string.}

\item{end_date}{Upper date as a string.}

\item{paginate}{When set to TRUE, fetches up to 1,000,000 rows of data}

\item{...}{Additional named values that are interpreted as Quandl API parameters.}
}
\value{
Returns a data.frame.
}
\description{
Retrieves Point In Time Data from the Quandl PIT endpoint.
Between start and end will show all rows that were visible at any point between two specified points in time. It works inclusively, a row visible exactly at start or exactly at end will be shown too.
}
\details{
Set your \code{api_key} with \code{Quandl.api_key} function. For instructions on finding your api key go to \url{https://www.quandl.com/account/profile}
}
\examples{
\dontrun{
Quandl.pit.between('RSM/MSB', '2020-06-11', '2020-06-12', paginate=TRUE)
}
}
\seealso{
\code{\link{Quandl.api_key}}
}
