% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkbd_functions.R
\name{dpkb}
\alias{dpkb}
\alias{rpkb}
\title{The Poisson kernel-based Distribution (PKBD)}
\usage{
dpkb(x, mu, rho, logdens = FALSE)

rpkb(n, mu, rho, method = "rejvmf")
}
\arguments{
\item{x}{Matrix (or data.frame) with number of columns >=2.}

\item{mu}{location vector parameter with length indicating the dimension of generated points.}

\item{rho}{is the concentration parameter, with 0 <= rho < 1.}

\item{logdens}{Logical; if 'TRUE', densities d are given as log(d).}

\item{n}{number of observations.}

\item{method}{string that indicates the method used for sampling observations. The available methods are 
\itemize{
   \item \code{'rejvmf'} acceptance-rejection algorithm using von Mises-Fisher envelops (Algorithm in Table 2 of Golzy and Markatou 2020);
   \item \code{'rejacg'} using angular central Gaussian envelops (Algorithm in Table 1 of Sablica et al. 2023);
   \item \code{'rejpsaw'} using projected Saw distributions (Algorithm in Table 2 of Sablica et al. 2023).
}}
}
\value{
\code{dpkb} gives the density value.
\code{rpkb} generates random observations from the PKBD. 

The number of observations generated is determined by \code{n} for \code{rpkb}.
This function returns a list with the matrix of generated observations \code{x},
the number of tries \code{numTries} and the number of acceptances \code{numAccepted}.
}
\description{
Density function and random number generation from the Poisson kernel-based Distribution
with mean direction vector \code{mu} and concentration parameter \code{rho}.
}
\examples{
# Generate some data from pkbd density
pkbd_dat <- rpkb(10, c(0.5,0), 0.5)

# Calculate the PKBD density values
dens_val <- dpkb(pkbd_dat$x, c(0.5,0.5),0.5)


}
\references{
Golzy, M., Markatou, M. (2020) Poisson Kernel-Based Clustering on the Sphere:
Convergence Properties, Identifiability, and a Method of Sampling, Journal of
Computational and Graphical Statistics, 29:4, 758-770, 
DOI: 10.1080/10618600.2020.1740713.

Sablica L., Hornik K., Leydold J. (2023) "Efficient sampling from the PKBD 
distribution", Electronic Journal of Statistics, 17(2), 2180-2209.
}
