% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0bootIDX_internal.R
\name{bootIDX}
\alias{bootIDX}
\title{Generate Bootstrap Indices}
\usage{
bootIDX(n, R)
}
\arguments{
\item{n}{positive \link[base]{integer} scalar, sample size}

\item{R}{positive \link[base]{integer} scalar, number of bootstrap replicates}
}
\value{
Function \code{\link[=bootIDX]{bootIDX()}} returns a \link[base]{list} of positive \link[base]{integer} \link[base]{vector}s.
Each element is the indices of one bootstrap sample.
}
\description{
Generate a series of \link[boot]{boot}strap indices.
}
\details{
Function \code{\link[=bootIDX]{bootIDX()}} is designed to generate the same bootstrap indices as
from the default options of function \link[boot]{boot},
given the same \link[base]{Random} seed.

See details in \code{boot:::index.array()} and \code{boot:::ordinary.array()}.
}
\examples{
set.seed(1345); boot::boot(data = 1:10, statistic = function(data, ind) ind, R = 3L)[['t']]
set.seed(1345); bootIDX(10L, R = 3L) # same copies of indices

}
\keyword{internal}
