% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleQp.R
\name{sampleQp}
\alias{sampleQp}
\title{Cluster-Specific Sample Quantiles}
\usage{
sampleQp(
  data,
  subjID = "PATIENT_ID",
  Qpredictor = "Marker",
  include = setdiff(names(data), y = c(Qpredictor)),
  exclude = NULL,
  from = 0.01,
  to = 0.99,
  by = 0.01,
  type = 7,
  ...
)
}
\arguments{
\item{data}{\link[base]{data.frame}}

\item{subjID}{\link[base]{character} scalar, column name of the subject/patient index in \code{data}}

\item{Qpredictor}{\link[base]{character} scalar, column name of the predictor variable}

\item{include}{\link[base]{character} \link{vector}, predictors to be included in output data set}

\item{exclude}{\link[base]{character} \link{vector}, predictors to be excluded from output data set}

\item{from, to, by}{see \link[base]{seq} a sequence of probabilities with starting, ending values, and interval
to calculate corresponding quantiles}

\item{type}{\link[base]{integer} scalar, type of the formula for quantiles,see \link[stats]{quantile}}

\item{...}{additional parameters, currently not in use}
}
\value{
\link{sampleQp} returns a \link[base]{data.frame}, with aggregated \link[survival]{Surv} endpoint and
\link[base]{numeric}, \link[base]{character}, or \link[base]{logical} predictors,
in addition to a \link[base]{matrix} of quantiles.
}
\description{
This function calculates vectors of sample quantiles in each independent cluster of observations (sample or subject)
Equidistant probabilities between user provided p_{min} and p_{max} are used (including both ends).
}
\details{
\link{sampleQp} calculates \eqn{N_p} sample quantiles in each independent cluster of observations
defined by \code{subjID} or \code{sampleID}.
Sample quantiles are stored in \eqn{N_p} columns for \eqn{Q(p)}, \eqn{p=1, \cdots, Np}
Additional subject-level predictors may be designated to be kept in the output data set.
Observation-level predictors should be excluded from the input data set.
}
\examples{
Ki67_Qps = sampleQp(data = Ki67, subjID = 'PATIENT_ID', 
  exclude = c('tissueID','inner_x','inner_y'), Qpredictor = 'Marker')
head(Ki67_Qps)
sapply(Ki67_Qps, FUN = class)   
head(Ki67_Qps$Marker)


}
