% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Qapprox_nc.R
\name{Qapprox_nc}
\alias{Qapprox_nc}
\title{Right-tail probability of quadratic forms (Q = X'AX) of noncentral Gaussian variables.}
\usage{
Qapprox_nc(q, mu, Sigma, A = NULL, method = "MR")
}
\arguments{
\item{q}{- quantile, could be a vector.}

\item{mu}{- mean vector of Gaussian variables.}

\item{Sigma}{- covariance matrix of Gaussian variables.}

\item{A}{- a positive-semi-definite matrix that defines the quadratic form.}

\item{method}{- "MR": moment-ratio (skewness-kurtosis) matching method; "SW": Satterthwaite-Welch method that matches mean and variance; "LTZ4": Liu-Tang-Zhang method that matches the kurtosis.}
}
\value{
The right-tail probability of a quadratic form (Q = X'AX) of noncentral Gaussian variables.
}
\description{
Right-tail probability of quadratic forms (Q = X'AX) of noncentral Gaussian variables.
}
\examples{
n = 100
Sigma = toeplitz(1/(1:n))
mu = rep(1, n)
thr = 500
Qapprox_nc(thr, mu, Sigma, method="SW")
Qapprox_nc(thr, mu, Sigma, method="LTZ4")
Qapprox_nc(thr, mu, Sigma, method="MR")
}
\references{
1. Hong Zhang, Judong Shen and Zheyang Wu. "An efficient and accurate approximation to the distribution of quadratic forms of Gaussian variables", arXiv:2005.00905.
}
