% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudo.pred.R
\name{pseudo.pred}
\alias{pseudo.pred}
\title{Generate a pseudo predator by sampling with replacement from prey
database.}
\usage{
pseudo.pred(diet, preybase, cal.vec, fat.vec, preysize = 2)
}
\arguments{
\item{diet}{compositional vector of proportions that sums to one.
Length is equal to the number of prey species.}

\item{preybase}{prey database with first column providing the species name.}

\item{cal.vec}{vector of calibration coefficients.}

\item{fat.vec}{vector of fat content whose length is the same as the number of species.}

\item{preysize}{number of prey to sample from prey database.}
}
\value{
a simulated predator FA signature
}
\description{
Note: if preysize=1, then one prey is selecting from each species.
      otherwise, a sample of size n_k (number of species k) is
      sampled with replacement.
}
\examples{
data(preyFAs)

# Note: uncomment examples to run. CRAN tests fail because execution time > 5 seconds
# p.mat <- matrix(rep(NA,100*11),nrow=100)
# for (i in 1: 100) {
#     my.seal <- pseudo.pred(rep(1/11,11),
#                            preyFAs[,-c(1,3)],
#                            rep(1,ncol(preyFAs[,-c(1,3)])-1),
#                            rep(1,11))
#     p.mat[i,] <- p.QFASA(my.seal,
#                          MEANmeth(preyFAs[,-c(1,3)]),
#                          rep(1,length(my.seal)),
#                          2,
#                          ext.fa=colnames(preyFAs[,-c(1:3)]))$`Diet Estimates`
# }
# 
# Average diet estimate 
# round(apply(p.mat,2,mean),3)

}
