% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{get_trial_obs_ontology}
\alias{get_trial_obs_ontology}
\title{Get the Traits Ontology/Metadata of the Current Active Trial}
\usage{
get_trial_obs_ontology()
}
\value{
A data frame containing the traits ontology or metadata, filtered by the observation 
variables used in the current trial.
}
\description{
Retrieves the traits ontology or metadata for the current active trial, which 
includes detailed information about the observation variables used in the trial.
}
\examples{
if (interactive()) {
  set_qbms_config("https://bms.icarda.org/ibpworkbench")
  login_bms()
  set_crop("wheat")
  set_program("Wheat International Nurseries")
  set_trial("IDYT39")
  ontology <- get_trial_obs_ontology()
}

}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}, \code{\link{set_program}}, \code{\link{set_trial}}, 
\code{\link{get_study_data}} for retrieving study observations.
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
