% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{login_oauth2}
\alias{login_oauth2}
\title{Login Using OAuth 2.0 Authentication}
\usage{
login_oauth2(
  authorize_url,
  access_url,
  client_id,
  client_secret = NULL,
  redirect_uri = "http://localhost:1410",
  oauth2_cache = FALSE
)
}
\arguments{
\item{authorize_url}{URL to send the client for authorization.}

\item{access_url}{URL used to exchange unauthenticated for authenticated token.}

\item{client_id}{Consumer key, also sometimes called the client ID.}

\item{client_secret}{Consumer secret, also sometimes called the client secret.}

\item{redirect_uri}{The URL that the user will be redirected to after authorization is complete (default is http://localhost:1410).}

\item{oauth2_cache}{A logical value or a string. TRUE means to cache using the default cache file .httr-oauth, FALSE means don't cache, 
and NA means to guess using some sensible heuristics. A string means use the specified path as the cache file.
Default is FALSE (i.e., don't cache).}
}
\value{
No return value.
}
\description{
If the request for an access token is valid, the authorization server needs 
to generate an access token and return these to the client, typically along 
with some additional properties about the authorization.
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
