% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GAD.R
\name{mleGAD}
\alias{mleGAD}
\title{Maximum likelihood estimation (MLE) for the generalized quantile-based asymmetric family of distributions (GAD).}
\usage{
mleGAD(y, f, g, lower = -Inf, upper = Inf)
}
\arguments{
\item{y}{This is a vector of quantiles.}

\item{f}{This is the reference density function \eqn{f} which is a standard version of a unimodal and symmetric around 0 density.}

\item{g}{This is the "link" function. The function \eqn{g} is to be differentiated. Therefore, \eqn{g} must be written as a function. For example, {g<-function(y)\{log(y)\}} for log link function.}

\item{lower}{This is the lower limit of the domain (support of the random variable) \eqn{f_{\alpha}^g(y;\eta,\phi)}, default {-Inf}.}

\item{upper}{This is the upper limit of the domain (support of the random variable) \eqn{f_{\alpha}^g(y;\eta,\phi)}, default {Inf}.}
}
\value{
The maximum likelihood estimate of parameter \eqn{\theta=(\eta,\phi,\alpha)} of the generalized quantile-based asymmetric family of densities
}
\description{
The log-likelihood function \eqn{\ell_n(\eta,\phi,\alpha)=\ln[L_n(\eta,\phi,\alpha)]}
and parameter estimation of \eqn{ \theta=(\eta,\phi,\alpha)} in the three parameter generalized quantile-based asymmetric family of densities
by using the maximum likelihood estimation are discussed in Gijbels et al. (2019b).
}
\examples{
# Example 1: Let F be a standard normal cumulative distribution function then
f_N<-function(s){dnorm(s, mean = 0,sd = 1)} # density function of N(0,1)
y<-rnorm(100)
g_id<-function(y){y}
g_log<-function(y){log(y)}
mleGAD(y,f=f_N,g=g_id) # For identity-link
mleGAD(rexp(100,0.1),f=f_N,g=g_log,lower = 0, upper = Inf) # For log-link


# Example 2: Let F be a standard Laplace cumulative distribution function then
f_La<-function(s){0.5*exp(-abs(s))} # density function of Laplace(0,1)
mleGAD(y,f=f_La,g=g_id) # For identity-link
mleGAD(rexp(100,0.1),f=f_La,g=g_log,lower = 0, upper = Inf) # For log-link
}
\references{
{


 Gijbels, I., Karim, R. and Verhasselt, A. (2019b). Quantile estimation in a generalized  asymmetric distributional setting. To appear in \emph{Springer Proceedings in Mathematics & Statistics, Proceedings of `SMSA 2019', the 14th Workshop on Stochastic Models, Statistics and their Application}, Dresden, Germany, in March 6--8, 2019. Editors: Ansgar Steland, Ewaryst Rafajlowicz, Ostap Okhrin.
}
}
