% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PyExec.R
\name{pyExecg}
\alias{pyExecg}
\title{Executes multiple lines of python code and gets the output}
\usage{
pyExecg(code, returnValues = character(), autoTypecast = TRUE,
  returnToR = TRUE, mergeNamespaces = FALSE, override = FALSE,
  simplify = TRUE)
}
\arguments{
\item{code}{a string of Python code to be executed in Python.}

\item{returnValues}{a character vector containing the names of the variables,
which should be returned to R.}

\item{autoTypecast}{a an optional logical value, default is TRUE, specifying
if the return values should be automatically typecasted if possible.}

\item{returnToR}{an optional logical, default is TRUE, specifying if the 
generated variables should be returned to R.}

\item{mergeNamespaces}{an optional logical, default is FALSE, specifying if 
the internally generated temporary namespace should be merged with the 
name space __main__. See \bold{Details}.}

\item{override}{an optional logical value, default is FALSE, specifying how to 
merge the temporary namespace with the __main__ namespace.}

\item{simplify}{an optional logical, if TRUE (default) R converts Python lists 
into R vectors whenever possible, else it translates Python lists 
always to R lists.}
}
\value{
Returns a list containing all the variables of the __main__ namespace.
}
\description{
The function pyExecg is designed to execute multiple lines of 
             Python code and returns the thereby generated variables to R.
}
\details{
The function pyExecg executes the code in a temporary namespace, 
         after the execution every variable from the namespace is returned 
         to R. If the mergeNamespaces is set to TRUE the temporary namespace
         gets merged with the (global) namespace __main__.
         The logical variable override is used to control, if already
         existing variables in the namespace __main__ should be overridden,
         when a variable with the same name get's assigned to the
         temporary namespace. If a python object can't be converted to an
         R object it is assigned to the Python dictionary __R__.namespace
         and the type, id and an indicator if the object is a callable are 
         returned.
}
\examples{
\dontshow{PythonInR:::pyCranConnect()}
if ( pyIsConnected() ){
# 1. assigns x to the global namespace
pyExec("x=4")
# 2. assigns y to the temp namespace
pyExecg("y=4", simplify=TRUE)
# 3. assign again to the temp namespace
pyExecg("
y=[i for i in range(1,4)]
x=[i for i in range(3,9)]
z=[i**2 for i in range(1,9)]
", returnValues=c("x", "z"), simplify=TRUE)
# 4. assign x to the temp namespace, x gets returned as vector
pyExecg("x=[i for i in range(0,5)]", simplify=TRUE)
# 5. assign x to the temp namespace, x gets returned as list
pyExecg("x=[i for i in range(0,5)]", simplify=FALSE)
# 6. x is still 4 since except assignment 1 all other assignments
#    took place in the temp namespace
pyPrint("x")
# 7. note y has never been assigned to the main namespace
"y" \%in\% pyDir()
# 8. since mergeNamespaces is TRUE PythonInR will try
#     to assign x to the main namespace but since override is
#     by default FALSE and x already exists in the main namespace
#     x will not be changed
pyExecg("x=10", simplify=TRUE, mergeNamespaces=TRUE)
# 9. there is no y in the main namespace therefore it can be assigned
pyExecg("y=10", simplify=TRUE, mergeNamespaces=TRUE)
pyPrint("x") # NOTE: x is still unchanged!
pyPrint("y") # NOTE: a value has been assigned to y!
# 10. since override is now TRUE the value of x will be changed in the
#      main namespace
pyExecg("x=10", simplify=TRUE, mergeNamespaces=TRUE, override=TRUE)
pyPrint("x") # NOTE: x is changed now!
# 11. get an object which can't be typecast to an R object
#     pyExecg does not transform these objects automatically
pyExec("import os")
z <- pyExecg("x = os")
os <- PythonInR:::pyTransformReturn(z[[1]])
os$getcwd()
}
}
