% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process-dir.R
\name{process_dir}
\alias{process_dir}
\title{Process a dir of files to generate normalised data and reports}
\usage{
process_dir(
  input_dir,
  output_dir = NULL,
  recurse = FALSE,
  flatten_output_dir = FALSE,
  layout_filepath = NULL,
  format = NULL,
  normalisation_types = c("RAU", "nMFI"),
  generate_reports = FALSE,
  merge_outputs = FALSE,
  column_collision_strategy = "intersection",
  return_plates = FALSE,
  dry_run = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{input_dir}{(\code{character(1)}) The directory containing the input files. It may be nested.}

\item{output_dir}{(\code{character(1)}) Optional overwrite directory where the output files should be saved. The default is \code{NULL}.
By default, the output directory is the same as the input directory.}

\item{recurse}{(\code{logical(1)}) If \code{TRUE}, the function will search for files recursively in the input directory. The default is \code{FALSE}.}

\item{flatten_output_dir}{(\code{logical(1)}) If \code{TRUE}, the output files will be saved in the output directory directly. The default is \code{FALSE}.}

\item{layout_filepath}{(\code{character(1)}) The path to the layout file. The default is \code{NULL}, and the layout file will have to
be determined automatically based on the file name.}

\item{format}{(\code{character(1)}) The format of the Luminex data. The default is \code{NULL}, and the format will have to
be determined automatically based on the file name. Available options are \code{xPONENT} and \code{INTELLIFLEX}.}

\item{normalisation_types}{(\code{character()}) A vector of normalisation types to use. The default is \code{c("RAU", "nMFI")}.}

\item{generate_reports}{(\code{logical(1)}) If \code{TRUE}, generate quality control reports for each file. The default is \code{FALSE}.}

\item{merge_outputs}{(\code{logical(1)}) If \code{TRUE}, merge the outputs of all plates into a single CSV file for each normalisation type.
The resulting file will be saved in the output directory with the name \verb{merged_\{normalisation_type\}_\{timestamp\}.csv}.
Example: \code{merged_nMFI_20250115_230735.csv}.}

\item{column_collision_strategy}{(\code{character(1)}) A method for handling missing or additional columns when merging outputs.
Possible options are \code{union} and \code{intersection}. The default is \code{intersection}.}

\item{return_plates}{(\code{logical(1)}) If \code{TRUE}, return a list of processed plates. The default is \code{FALSE}.}

\item{dry_run}{(\code{logical(1)}) If \code{TRUE}, the function will not process any files
but will print the information about the files that would be processed. The default is \code{FALSE}.}

\item{verbose}{(\code{logical(1)}) Print additional information. The default is \code{TRUE}.}

\item{...}{Additional arguments to for the \code{process_file} function.}
}
\value{
If the \code{return_plates} parameter is set to \code{TRUE} the function returns a list of plates
sorted by the \code{plate_datetime} (The time of the experiment noted in the csv file) in increasing order (oldest plates first).
If the \code{return_plates} parameters is set to \code{FALSE} the function returns \code{NULL}.
}
\description{
The output files will be created alongside their corresponding input files, preserving
the directory structure of the input directory unless the \code{flatten_output_dir} parameter is set to \code{TRUE}.
}
\examples{
# Select input directory to process
dir <- system.file("extdata", "multiplate_lite", package = "PvSTATEM", mustWork = TRUE)

# Select output directory
output_dir <- tempdir(check = TRUE)

# Process input directory and return plates
plates <- process_dir(dir, return_plates = TRUE, output_dir = output_dir)

}
