% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes-model.R
\name{handle_high_dose_hook}
\alias{handle_high_dose_hook}
\title{Detect and handle the high dose hook effect}
\usage{
handle_high_dose_hook(mfi, dilutions, high_dose_threshold = 1/200)
}
\arguments{
\item{mfi}{(\code{numeric()})}

\item{dilutions}{(\code{numeric()})}

\item{high_dose_threshold}{(\code{numeric(1)}) MFI values associated
with dilutions above this threshold should be checked for the high dose hook effect}
}
\value{
sample selector (\code{logical()})
}
\description{
Typically, the MFI values associated with standard curve
samples should decrease as we dilute the samples. However,
sometimes in high dilutions, the MFI presents a non monotonic behavior.
In that case, MFI values associated with dilutions above (or equal to)
\code{high_dose_threshold} should be removed from the analysis.

For the \code{nplr} model the recommended number of standard curve samples
is at least 4. If the high dose hook effect is detected but the number
of samples below the \code{high_dose_threshold} is lower than 4,
additional warning is printed and the samples are not removed.

The function returns a logical vector that can be used to subset the MFI values.
}
