% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-RoBMA.R
\name{method.RoBMA}
\alias{method.RoBMA}
\title{Robust Bayesian Meta-Analysis (RoBMA) Method}
\usage{
\method{method}{RoBMA}(method_name, data, settings)
}
\arguments{
\item{method_name}{Method name (automatically passed)}

\item{data}{Data frame with yi (effect sizes), sei (standard errors), es_type
(either \code{"SMD"} for Cohen's d / Hedge's g, \code{"logOR"} for log odds
ratio, \code{"z"} for Fisher's z, or \code{"r"} for correlations. Defaults to
\code{"none"} which re-scales the default priors to unit-information width based
on total sample size supplied \code{"ni"}.)}

\item{settings}{List of method settings (see Details.)}
}
\value{
Data frame with RoBMA results
}
\description{
Implements the robust Bayesian meta-analysis (RoBMA) method that uses
Bayesian model-averaging to combine results across several complementary
publication bias adjustment methods. See
\insertCite{maier2023robust;textual}{PublicationBiasBenchmark} and
\insertCite{bartos2023robust;textual}{PublicationBiasBenchmark} for
details.

Note that the prior settings is dispatched based on \code{"es_type"} column attached
to the dataset. The resulting estimates are then summarized on the same scale
as was the dataset input (for \code{"r"}, heterogeneity is summarized on Fisher's z).

\strong{Important:} This method requires JAGS (Just Another Gibbs Sampler) to be
installed on your system. Please download and install JAGS from
\url{https://mcmc-jags.sourceforge.io/} before using this method.
}
\details{
The following settings are implemented \describe{
\item{\code{"default"}}{RoBMA-PSMA with publication bias adjustment as described in
\insertCite{bartos2023robust;textual}{PublicationBiasBenchmark}.
(the MCMC settings was reduced to speed-up the simulations) with the
three-level specification whenever \code{"study_ids"} are supplied with the data}
\item{\code{"PSMA"}}{RoBMA-PSMA with publication bias adjustment as described in
\insertCite{bartos2023robust;textual}{PublicationBiasBenchmark}.
(the MCMC settings was reduced to speed-up the simulations) with the
three-level specification whenever \code{"study_ids"} are supplied with the data}
}
}
\examples{
\donttest{
# Generate some example data
data <- data.frame(
  yi      = c(0.2, 0.3, 0.1, 0.4, 0.25),
  sei     = c(0.1, 0.15, 0.08, 0.12, 0.09),
  es_type = "SMD"
)

# Apply RoBMA method
result <- run_method("RoBMA", data)
print(result)
}
}
\references{
\insertAllCited{}
}
