% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_properties.R
\name{get_properties}
\alias{get_properties}
\title{Retrieve Compound Properties from PubChem}
\usage{
get_properties(
  properties,
  identifier,
  namespace = "cid",
  searchtype = NULL,
  as_dataframe = FALSE,
  options = NULL
)
}
\arguments{
\item{properties}{A character vector specifying the properties to be retrieved.}

\item{identifier}{A vector of positive integers (e.g. cid, sid, aid) or identifier strings (source, inchikey, formula). In some cases, only a single identifier string (name, smiles, xref; inchi, sdf by POST only).}

\item{namespace}{Specifies the namespace for the query. For the 'compound' domain, possible values include 'cid', 'name', 'smiles', 'inchi', 'sdf', 'inchikey', 'formula', 'substructure', 'superstructure', 'similarity', 'identity', 'xref', 'listkey', 'fastidentity', 'fastsimilarity_2d', 'fastsimilarity_3d', 'fastsubstructure', 'fastsuperstructure', and 'fastformula'. For other domains, the possible namespaces are domain-specific.}

\item{searchtype}{Specifies the type of search to be performed. For structure searches, possible values are combinations of 'substructure', 'superstructure', 'similarity', 'identity' with 'smiles', 'inchi', 'sdf', 'cid'. For fast searches, possible values are combinations of 'fastidentity', 'fastsimilarity_2d', 'fastsimilarity_3d', 'fastsubstructure', 'fastsuperstructure' with 'smiles', 'smarts', 'inchi', 'sdf', 'cid', or 'fastformula'.}

\item{as_dataframe}{If TRUE it return a dataframe.}

\item{options}{Additional arguments passed to \code{\link{get_json}}.}
}
\value{
If `as_dataframe` is FALSE, a named list where each element corresponds to the properties retrieved from PubChem.
        If `as_dataframe` is TRUE, a dataframe where each row corresponds to the properties retrieved from PubChem.
        The names of the list elements or row names of the dataframe are based on the provided identifiers.
}
\description{
This function sends a request to PubChem to retrieve compound properties based on the specified parameters.
It returns a list or dataframe of properties corresponding to the provided identifiers.
}
\examples{
get_properties(
  properties = "IsomericSMILES",
  identifier = "aspirin",
  namespace = "name"
)
}
