% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeNetCDF.R
\name{writeSim2netCDF}
\alias{writeSim2netCDF}
\title{A function to write netCDF-files}
\usage{
writeSim2netCDF(
  df,
  comment1 = NA,
  comment2 = NA,
  institution = "PIK",
  contact = "isi-mip@pik-potsdam.de",
  modelname = "formind",
  GCM = "hadgem",
  RCP = "rcp85",
  ses = "nat",
  ss = "co2const",
  region = "Kroof",
  start = "1980",
  folder = "ISI-MIP"
)
}
\arguments{
\item{df}{A data.frame containing in the first three columns longitude latitude
and time. These columns are followed by columns containing the output variables.
 The columns have to be named with the output variable name as required by the 2B
 protocol. See table 21.}

\item{comment1}{Optional comment regarding your simulation}

\item{comment2}{Optional comment regarding your simulation}

\item{institution}{Your institution}

\item{contact}{Your mail address}

\item{modelname}{The name of the used forest model}

\item{GCM}{The climate model which created the used climate time series}

\item{RCP}{The RCP scenario}

\item{ses}{The scenario describing forest management. UMsoc equals the "nat"
settings and histsoc and 2005soc equal the "man" settings in the ISIMIP2a
protocol. Default value: "nat".}

\item{ss}{"co2" for all experiments other than the sensitivity experiments
for which 2005co2 is explicitly written.  Note: even models in which CO2 has
no effect should use the co2 identifier relevant to the experiment.  Default
value: "co2const".}

\item{region}{the region or site of the simulation}

\item{start}{the start year of the simulation. Default value: 1980.}

\item{folder}{The folder in which all netCDF files will be written}
}
\description{
This function transforms simulation results into netCDF files following the ISIMIP2 protocol
}
\details{
The function transforms your simulation output data frame into several netCDF
-files and writes them into the indicated folder using the naming convention of
 the ISIMIP2(B)-protocol (https://www.isimip.org/protocol/). Units and long names
 of variables (table 21) will be created automatically.
}
\examples{
# Produce sample data 
df <- data.frame(lat = rep(20, 10),
                 lon = rep(30, 10),
                 time = seq(1920, 2010, 10),
                 dbh_total = c(10:19),
                 nee_total = rnorm(10, -0.5, 0.25),
                 evap = rnorm(10, 0.001, 0.0001),
                 cwood_fasy = seq(40, 85, 5))

# Convert multi-variable data.frame into single-variable netCDFs using ISIMIP naming conventions
writeSim2netCDF(df = df,
                comment1 = NA,
                comment2 = NA,
                institution = 'PIK',
                contact = 'isi-mip@pik-potsdam.de',
                modelname = "formind",
                GCM = "hadgem",
                RCP = "rcp85",
                ses = "nat",
                ss = "co2const",
                region = "Kroof",
                start = '1920',
                folder = tempdir())
}
\author{
Friedrich J. Bohn
}
