% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11MODPlugHelpers.r
\name{MODPlugToPTPattern}
\alias{MODPlugToPTPattern}
\title{Convert MODPlug pattern into a PTPattern object}
\usage{
MODPlugToPTPattern(text = NULL, what = c("PTPattern", "PTBlock"))
}
\arguments{
\item{text}{A \code{vector} of \code{character}s, representing MOD pattern data
obtained from OpenMPT. If set to \code{NULL} (default), the text will be read
from the system's clipboard.}

\item{what}{A \code{character} string that indicates what type of object
should be returned. Can be "PTPattern" or "PTBlock".}
}
\value{
Depending on the value of the argument \code{what}, it will
return either a \code{\link{PTPattern}} or \code{\link{PTBlock}} object.
}
\description{
Convert pattern data from text or clipboard, originating from the modern
MODPlug tracker and convert it into a \code{PTPattern} or \code{PTBlock}
object.
}
\details{
The Open MODPlug Tracker (\url{https://openmpt.org}) is a modern
music tracker that is for free. It too can handle ProTracker modules.
This function assists in moving pattern data from Open MPT to R.

Simply select and copy the pattern data to the system's clipboard
and use this function to import it to R as a \code{\link{PTPattern}} or
\code{\link{PTBlock}} object.
}
\examples{
\dontrun{
## This is what Mod Plug Pattern data looks like on
## the system's clipboard:
modPlugPattern <- c("ModPlug Tracker MOD",
                    "|C-601...A08|C-602...C40|A#403...F06|A#504......",
                    "|...01...A08|C-602...C30|........A01|........A02",
                    "|...01...A08|C-602......|........A01|C-604......",
                    "|...........|C-602......|........A02|........A02",
                    "|...01...A08|C-602......|........120|D-604......",
                    "|...........|A#504...C08|........A02|........A02",
                    "|...01...A08|C-602......|........220|D#604......",
                    "|...........|A#504...C08|........A01|........A02",
                    "|...01...A08|C-602......|........A01|F-604......",
                    "|...........|A#604...C08|........A01|........A02",
                    "|...01...A08|C-602......|........A01|D#604......",
                    "|...........|G-604...C08|........A01|........A02",
                    "|G-601......|C-602......|........A01|D-604......",
                    "|........A08|F-604...C08|...........|........A02",
                    "|F-601......|C-602......|...........|C-604......",
                    "|........A08|A#504...C08|...........|........A02",
                    "|C-601...A08|C-602...C40|A#403...F06|A#504......",
                    "|...01...A08|C-602...C30|........A01|........A02",
                    "|...01...A08|C-602......|........A01|D-604......",
                    "|...........|C-602......|........A02|........A02",
                    "|...01...A08|C-602......|........120|F-504......",
                    "|...........|A#504...C08|........A02|........A02",
                    "|...01...A08|C-602......|........220|G-504......",
                    "|...........|A#504...C08|........A01|........A02",
                    "|...01...A08|C-602......|........A01|A#504......",
                    "|...........|A#604...C08|........A01|........A01",
                    "|...01...A08|C-602......|........A01|...........",
                    "|...........|G-604...C08|........A01|........A01",
                    "|G-501......|C-602......|........A01|...........",
                    "|........A08|F-504...C08|...........|........A01",
                    "|A-501......|C-602......|...........|...........",
                    "|........A08|G-504...C08|...........|........A01",
                    "|E-601...A08|C-602...C40|D-503......|D-604......",
                    "|...01...A08|C-602...C30|........A01|........A02",
                    "|...01...A08|C-602......|........A01|E-604......",
                    "|...........|C-602......|........A02|........A02",
                    "|...01...A08|C-602......|........126|F#604......",
                    "|...........|D-604...C08|........A02|........A02",
                    "|...01...A08|C-602......|........226|G-604......",
                    "|...........|E-604...C08|........A01|........A02",
                    "|...01...A08|C-602......|........A01|A-604......",
                    "|...........|D-604...C08|........A01|........A02",
                    "|...01...A08|C-602......|........A01|G-604......",
                    "|...........|D-604...C08|........A01|........A02",
                    "|B-601......|C-602......|........A01|F#604......",
                    "|........A08|D-604...C08|...........|........A02",
                    "|A-601......|C-602......|...........|E-604......",
                    "|........A08|E-504...C08|...........|........A02",
                    "|D-601...A08|C-602...C40|C-503......|C-604......",
                    "|...01...A08|C-602...C30|........A01|........A02",
                    "|...01...A08|C-602......|........A01|D-604......",
                    "|...........|C-602......|........A02|........A02",
                    "|...01...A08|C-602......|........12B|E-604......",
                    "|...........|G-604...C08|........A02|........A02",
                    "|...01...A08|C-602......|........22B|F-604......",
                    "|...........|G-604...C08|........A01|........A02",
                    "|...01...A08|C-602......|........A01|G-604......",
                    "|...........|E-604...C08|........A01|........A02",
                    "|...01...A08|C-602......|........A01|F-604......",
                    "|...........|C-604...C08|........A01|........A02",
                    "|A-601......|C-602......|........A01|E-604......",
                    "|........A08|G-604...C08|...........|........A02",
                    "|G-601......|F-604...C08|...........|D-604......",
                    "|........A08|C-604...C08|...........|........A02")

## You could read it directly from the clipboard,
## by leaving text NULL (default). Here we provide
## the text specified above:
pat <- MODPlugToPTPattern(modPlugPattern, "PTPattern")

## look it is a "PTPattern" object now:
class(pat)

## we can also only import the first 10 lines as a
## PTBlock:
blk <- MODPlugToPTPattern(modPlugPattern[1:10], "PTBlock")
}
}
\seealso{
Other MODPlug.operations: 
\code{\link{PTPatternToMODPlug}()}

Other pattern.operations: 
\code{\link{PTPattern-class}},
\code{\link{PTPattern-method}},
\code{\link{PTPatternToMODPlug}()},
\code{\link{appendPattern}()},
\code{\link{deletePattern}()},
\code{\link{pasteBlock}()},
\code{\link{patternLength}()},
\code{\link{patternOrderLength}()},
\code{\link{patternOrder}()}
}
\author{
Pepijn de Vries
}
\concept{MODPlug.operations}
\concept{pattern.operations}
