% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/05PTSample.r
\docType{methods}
\name{waveform}
\alias{waveform}
\alias{waveform,PTSample-method}
\alias{waveform<-}
\alias{waveform<-,PTSample-method}
\title{Extract or replace a PTSample waveform}
\usage{
\S4method{waveform}{PTSample}(sample, start.pos = 1,
  stop.pos = sampleLength(sample), loop = TRUE)

\S4method{waveform}{PTSample}(sample) <- value
}
\arguments{
\item{sample}{A \code{\link{PTSample}} object from which the waveform needs to
be extracted or replaced.}

\item{start.pos}{A \code{numeric} starting index, giving the starting
position for the waveform to be returned. Default value is \code{1}. This
index should be greater than zero.}

\item{stop.pos}{A \code{numeric} stopping index, giving the stopping
position for the waveform to be returned. Default value is
\code{sampleLength(sample)} This index should be greater than
\code{start.pos}.}

\item{loop}{A \code{logical} value indicating whether the waveform
should be modulated between the specified loop positions
(see \code{\link{loopStart}} and \code{\link{loopLength}}),
or the waveform should stop at the end of the sample (padded with \code{NA}
values beyond the sample length). Will do the first
when set to \code{TRUE} and the latter when set to \code{FALSE}.}

\item{value}{A \code{vector} of numeric values ranging from 0 up to 255,
representing the waveform that should be used to replace that of object
\code{sample}. The length should be even and not exceed \code{2*0xffff} =
\code{131070}. \code{\link{loopStart}} and \code{\link{loopLength}} will
be adjusted automatically when they are out of range for the new waveform.

Use \code{NA} to generate an empty/blank \code{\link{PTSample}} object.}
}
\value{
For \code{waveform}, the waveform of \code{sample} is returned
as a \code{vector} of \code{numeric} values ranging from 0 up to 255.
If '\code{loop}' is set to \code{FALSE}
and the starting position is beyond the sample length, \code{NA} values
are returned. If '\code{loop}' is set to \code{TRUE} and the starting
position is beyond the sample loop (if present, see
\code{\link{loopState}}), the waveform is modulated between the loop
positions.

For \code{waveform<-}, a copy of object \code{sample} is returned in which
the waveform has been replaced with \code{value}.
}
\description{
Extract or replace the waveform of a \code{\link{PTSample}} object. The
waveform is represented by a \code{vector} of numeric values ranging from
0 up to 255.
}
\details{
Sample waveforms are stored as 8 bit signed short integer values ranging
from -128 up to +127 in original ProTracker files. However, as the
\code{\link{PTSample}} class extends the \code{\link[tuneR]{Wave}} class,
the waveforms are represented by integer values ranging from 0 up to 255
in the \link{ProTrackR} package. As per ProTracker specifications,
samples are of 8 bit mono quality and can only have an even length with
a maximum of \code{2*0xffff} = \code{131070}. This method can be used to
extract a waveform or replace it.
}
\examples{
data("mod.intro")

## Loop sample #1 of mod.intro beyond it's
## length of 1040 samples:
wav1 <- waveform(PTSample(mod.intro, 1),
                 1, 5000)

## get the waveform from sample #2
## of mod.intro:
wav2 <- waveform(PTSample(mod.intro, 2))

## create an echo effect using
## the extracted waveform:
wav2 <- c(wav2, rep(128, 1000)) +
        c(rep(128, 1000), wav2)*0.25 - 25

## assign this echoed sample to
## sample #2 in mod.intro:
waveform(PTSample(mod.intro, 2)) <- wav2

## Blank out sample #1 in mod.intro:
waveform(PTSample(mod.intro, 1)) <- NA
}
\author{
Pepijn de Vries
}
\seealso{
Other integer.operations: \code{\link{hiNybble}},
  \code{\link{loNybble}}, \code{\link{nybble}};
  \code{\link{nybbleToSignedInt}};
  \code{\link{rawToSignedInt}};
  \code{\link{rawToUnsignedInt}};
  \code{\link{signedIntToNybble}};
  \code{\link{signedIntToRaw}};
  \code{\link{unsignedIntToRaw}}

Other sample.operations: \code{\link{PTSample,PTModule,numeric-method}},
  \code{\link{PTSample,Wave,missing-method}},
  \code{\link{PTSample,raw,missing-method}},
  \code{\link{PTSample-method}}, \code{\link{PTSample<-}},
  \code{\link{PTSample<-,PTModule,numeric,PTSample-method}};
  \code{\link{PTSample}}, \code{\link{PTSample-class}};
  \code{\link{fineTune}},
  \code{\link{fineTune,PTSample-method}},
  \code{\link{fineTune<-}},
  \code{\link{fineTune<-,PTSample,numeric-method}};
  \code{\link{loopLength}},
  \code{\link{loopLength,PTSample-method}},
  \code{\link{loopLength<-}},
  \code{\link{loopLength<-,PTSample-method}};
  \code{\link{loopSample}},
  \code{\link{loopSample,PTSample-method}};
  \code{\link{loopStart}},
  \code{\link{loopStart,PTSample-method}},
  \code{\link{loopStart<-}},
  \code{\link{loopStart<-,PTSample-method}};
  \code{\link{loopState}},
  \code{\link{loopState,PTSample-method}};
  \code{\link{name}}, \code{\link{name,PTModule-method}},
  \code{\link{name,PTSample-method}}, \code{\link{name<-}},
  \code{\link{name<-,PTModule,character-method}},
  \code{\link{name<-,PTSample,character-method}};
  \code{\link{playSample}},
  \code{\link{playSample,PTModule-method}},
  \code{\link{playSample,PTSample-method}};
  \code{\link{read.sample}},
  \code{\link{read.sample,character-method}};
  \code{\link{sampleLength}},
  \code{\link{sampleLength,PTSample-method}};
  \code{\link{volume}},
  \code{\link{volume,PTSample-method}},
  \code{\link{volume<-}},
  \code{\link{volume<-,PTSample,numeric-method}};
  \code{\link{write.sample}},
  \code{\link{write.sample,PTSample,character-method}}
}

