% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/01supporting_functions.r
\name{periodToChar}
\alias{periodToChar}
\title{Get the note and octave from period table}
\usage{
periodToChar(period)
}
\arguments{
\item{period}{\code{integer} value of a period value.}
}
\value{
\code{periodToChar} returns a \code{character} representing the combination
of octave and note that is closest to
\code{period} in the ProTracker period table.
}
\description{
These functions return the note and octave that is closest to the provided period value.
}
\details{
ProTracker uses a \link{period_table} to link period values to certain
octaves and notes. This function serves to look up corresponding
notes and octaves for specific period values.
}
\examples{
## Note C# in octave 3 is closest to a period of 200 in the table:
periodToChar(200)
## try with a range of period values:
periodToChar(200:400)
}
\author{
Pepijn de Vries
}
\seealso{
Other character.operations: \code{\link{as.character}},
  \code{\link{as.character,PTCell-method}},
  \code{\link{as.character,PTPattern-method}},
  \code{\link{as.character,PTTrack-method}};
  \code{\link{name}}, \code{\link{name,PTModule-method}},
  \code{\link{name,PTSample-method}}, \code{\link{name<-}},
  \code{\link{name<-,PTModule,character-method}},
  \code{\link{name<-,PTSample,character-method}};
  \code{\link{noteToSampleRate}},
  \code{\link{periodToSampleRate}},
  \code{\link{periodToSampleRate}},
  \code{\link{sampleRate}}, \code{\link{sampleRate}};
  \code{\link{rawToCharNull}}

Other note.and.octave.operations: \code{\link{noteDown}},
  \code{\link{noteDown,PTCell-method}},
  \code{\link{noteDown,PTPattern-method}},
  \code{\link{noteDown,PTTrack-method}},
  \code{\link{noteUp}}, \code{\link{noteUp,PTCell-method}},
  \code{\link{noteUp,PTPattern-method}},
  \code{\link{noteUp,PTTrack-method}},
  \code{\link{octaveDown}},
  \code{\link{octaveDown,PTCell-method}},
  \code{\link{octaveDown,PTPattern-method}},
  \code{\link{octaveDown,PTTrack-method}},
  \code{\link{octaveUp}},
  \code{\link{octaveUp,PTCell-method}},
  \code{\link{octaveUp,PTPattern-method}},
  \code{\link{octaveUp,PTTrack-method}};
  \code{\link{noteToPeriod}};
  \code{\link{noteToSampleRate}},
  \code{\link{periodToSampleRate}},
  \code{\link{periodToSampleRate}},
  \code{\link{sampleRate}}, \code{\link{sampleRate}};
  \code{\link{note}}, \code{\link{note,PTCell-method}},
  \code{\link{note,numeric-method}}, \code{\link{note<-}},
  \code{\link{note<-,PTCell,character-method}};
  \code{\link{octave}}, \code{\link{octave,PTCell-method}},
  \code{\link{octave,numeric-method}},
  \code{\link{octave<-}},
  \code{\link{octave<-,PTCell,numeric-method}}

Other period.operations: \code{\link{noteToPeriod}};
  \code{\link{noteToSampleRate}},
  \code{\link{periodToSampleRate}},
  \code{\link{periodToSampleRate}},
  \code{\link{sampleRate}}, \code{\link{sampleRate}};
  \code{\link{note}}, \code{\link{note,PTCell-method}},
  \code{\link{note,numeric-method}}, \code{\link{note<-}},
  \code{\link{note<-,PTCell,character-method}};
  \code{\link{octave}}, \code{\link{octave,PTCell-method}},
  \code{\link{octave,numeric-method}},
  \code{\link{octave<-}},
  \code{\link{octave<-,PTCell,numeric-method}};
  \code{\link{period_table}}
}

