% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_specific_bill.R
\name{get_specific_bill}
\alias{get_specific_bill}
\title{Get a Specific Bill}
\usage{
get_specific_bill(congress, bill_id, page = 1, myAPI_Key)
}
\arguments{
\item{congress}{105-116}

\item{bill_id}{a bill slug, for example hr4881 - these can be found in the recent bill response.}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves details about a particular bill, including actions taken and votes
}
\description{
The attributes house_passage_vote and senate_passage_vote are populated (with the date of passage) only upon successful passage of the bill. Bills before the 113th Congress (prior to 2013) have fewer attribute values than those from the 113th Congress onward, because the more recent bill data comes from the bulk data provided by the Government Publishing Office. Details for the older bills came from scraping Thomas.gov, the former congressional site of the Library of Congress. HTTP Request: GET https://api.propublica.org/congress/v1/{congress}/bills/{bill-id}.json
}
\examples{
\dontrun{
get_specific_bill(115, 'hr21')
}
}
