% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/get_independent_expenditure_support_presidential_candidate.R
\name{get_independent_expenditure_support_presidential_candidate}
\alias{get_independent_expenditure_support_presidential_candidate}
\title{Get Independent Expenditures that Support or Oppose Presidential Candidates}
\usage{
get_independent_expenditure_support_presidential_candidate(
  cycle = 2018,
  page = 1,
  myAPI_Key
)
}
\arguments{
\item{cycle}{The election cycle}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves the 200 most recent independent expenditures in support of or opposition to any presidential candidate.
}
\description{
#HTTP Request: GET https://api.propublica.org/campaign-finance/v1/{cycle}/president/independent_expenditures
}
\examples{
\donttest{
get_independent_expenditure_support_presidential_candidate(2016)
}
}
