% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{ProFAST_run}
\alias{ProFAST_run}
\title{(Varitional) ICM-EM algorithm for implementing ProFAST model}
\usage{
ProFAST_run(
  XList,
  AdjList,
  q = 15,
  fit.model = c("gaussian", "poisson"),
  AList = NULL,
  maxIter = 25,
  epsLogLik = 1e-05,
  verbose = TRUE,
  seed = 1,
  error_heter = TRUE,
  Psi_diag = FALSE,
  Vint_zero = FALSE
)
}
\arguments{
\item{XList}{an M-length list consisting of multiple matrices with class \code{dgCMatrix} or \code{matrix} that specifies the count/log-count gene expression matrix for each data batch used for ProFAST model.}

\item{AdjList}{an M-length list of sparse matrices with class \code{dgCMatrix}, specify the adjacency matrix used for intrisic CAR model in ProFAST. We provide this interface for those users who would like to define the adjacency matrix by themselves.}

\item{q}{an optional integer, specify the number of low-dimensional embeddings to extract in ProFAST. Larger q means more information extracted.}

\item{fit.model}{an optional string, specify the version of ProFAST to be fitted. The Gaussian version models the log-count matrices while the Poisson verions models the count matrices; default as \code{gaussian} due to fastter computation.}

\item{AList}{an optional list with each component being a vector whose length is equal to the rows of component in \code{XList}, specify the normalization factor in ProFAST. The default is \code{NULL} that means the normalization factor equal to 1.}

\item{maxIter}{the maximum iteration of ICM-EM algorithm. The default is 30.}

\item{epsLogLik}{an optional positive vlaue, tolerance of relative variation rate of the observed pseudo loglikelihood value, defualt as '1e-5'.}

\item{verbose}{a logical value, whether output the information in iteration.}

\item{seed}{a postive integer, the random seed to be set in initialization.}

\item{error_heter}{a logical value, whether use the heterogenous error for ProFAST model, default as \code{TRUE}. If \code{error.heter=FALSE}, then the homogenuous error is used.}

\item{Psi_diag}{a logical value, whether set the conditional covariance matrix of the intrisic CAR to diagonal, default as \code{FALSE}.}

\item{Vint_zero}{an optional logical value, specify whether the intial value of intrisic CAR component is set to zero; default as \code{FALSE}.}
}
\value{
return a list including the following components: (1) hV: an M-length list consisting of spatial embeddings in ProFAST; (2) nu: the estimated intercept vector; (3) Psi: the estimated covariance matrix; (4) W: the estimated shared loading matrix; (5) Lam: the estimated covariance matrix of error term; (6): ELBO: the ELBO value when algorithm convergence; (7) ELBO_seq: the ELBO values for all itrations.
}
\description{
(Varitional) ICM-EM algorithm for implementing ProFAST model
}
\details{
None
}
\references{
None
}
\seealso{
\code{\link{ProFAST_structure}}, \code{\link{ProFAST}}, \code{\link{model_set_ProFAST}}
}
