% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly_powerest.R
\name{plotly_powerest}
\alias{plotly_powerest}
\title{3D interactive visualization}
\usage{
plotly_powerest(pred,opacity=0.8,colors='BrBG',fig_title=NULL)
}
\arguments{
\item{pred}{The result from 'pred_powerest'.}

\item{opacity}{The opacity of the graph, default=0.8.}

\item{colors}{The color for the graph, default='BrBG'.}

\item{fig_title}{The title of the graph, default=NULL.}
}
\value{
A 3d interactive plot of the power surface. Users can also plot multiple surfaces together to compare them.
}
\description{
This function creates 3d interactive plot of the power against other parameters based on 'plot_ly'.
}
\examples{
data(result_example)
 \donttest{b<-fit_powerest(result_example$power,result_example$avg_logFC,result_example$avg_PCT)}
 \donttest{pred <- pred_powerest(b,xlim= c(0,6),ylim=c(0,1))}
 \donttest{plotly_powerest(pred,fig_title='Power estimation result')}

}
\author{
Lan Shui \email{lshui@mdanderson.org}
}
