% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/german_credit_loader.R
\name{get_german_credit_file}
\alias{get_german_credit_file}
\title{Get the file with the German Statlog credit dataset}
\usage{
get_german_credit_file()
}
\value{
A file with the plain-text raw data for the German Statlog credit
  that ships with this package (extension \code{.dat}).
}
\description{
The file contains a local copy of the German Statlog credit dataset with
1,000 observations and 24 features. The data page is at:
https://archive.ics.uci.edu/ml/datasets/statlog+(german+credit+data) and the
original files at:
http://archive.ics.uci.edu/ml/machine-learning-databases/statlog/german/ We
use the file `german.data-numeric`, which has 24 covariates instead of the 20
in the original data (as some are qualitative).
}
\examples{
f <- get_german_credit_file()
writeLines(readLines(f, n=5))

}
