% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_analytics.R
\name{analyze_drawdowns}
\alias{analyze_drawdowns}
\title{Analyze Drawdown Characteristics}
\usage{
analyze_drawdowns(drawdowns, returns)
}
\arguments{
\item{drawdowns}{Drawdown series (negative values)}

\item{returns}{Return series for additional metrics}
}
\value{
List with drawdown statistics
}
\description{
Detailed analysis of drawdown periods including depth, duration, and recovery.
}
\examples{
data("sample_prices_weekly")
momentum <- calc_momentum(sample_prices_weekly, lookback = 12)
selected <- filter_top_n(momentum, n = 10)
weights <- weight_equally(selected)
result <- run_backtest(sample_prices_weekly, weights)
dd_analysis <- analyze_drawdowns(result$portfolio_value, result$dates)
}
