% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_adapters.R
\name{sql_adapter_adjusted}
\alias{sql_adapter_adjusted}
\title{Load Adjusted Price Data from SQL Database}
\usage{
sql_adapter_adjusted(
  db_path,
  symbols,
  start_date = NULL,
  end_date = NULL,
  auto_update = FALSE,
  frequency = "daily",
  use_adjusted = TRUE
)
}
\arguments{
\item{db_path}{Path to SQLite database file}

\item{symbols}{Character vector of stock symbols to load}

\item{start_date}{Start date (YYYY-MM-DD) or NULL}

\item{end_date}{End date (YYYY-MM-DD) or NULL}

\item{auto_update}{Auto-update database (default: FALSE)}

\item{frequency}{"daily", "weekly", or "monthly" (default: "daily")}

\item{use_adjusted}{Use adjusted prices if available (default: TRUE)}
}
\value{
data.table with Date column and adjusted prices per symbol
}
\description{
Loads adjusted stock prices (for splits/dividends) from SQLite.
}
\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE) && file.exists("sp500.db")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
prices <- sql_adapter_adjusted(
  db_path   = "sp500.db",
  symbols   = c("AAPL", "MSFT"),
  start_date = "2020-01-01",
  end_date   = "2020-12-31",
  frequency  = "monthly"
)
head(prices)
}
\dontshow{\}) # examplesIf}
}
