% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sample_prices_weekly}
\alias{sample_prices_weekly}
\title{Sample Weekly Stock Prices}
\format{
A data.table with 158 rows and 21 columns:
\describe{
\item{Date}{Date object, weekly closing date (typically Friday)}
\item{AAPL}{Apple Inc. adjusted closing price}
\item{AMZN}{Amazon.com Inc. adjusted closing price}
\item{BA}{Boeing Co. adjusted closing price}
\item{BAC}{Bank of America Corp. adjusted closing price}
\item{...}{Additional stock symbols with adjusted closing prices}
}
}
\source{
Yahoo Finance historical data, adjusted for splits and dividends
}
\usage{
data(sample_prices_weekly)
}
\description{
Weekly closing prices for 20 stocks from 2017-2019. Data includes
major stocks from various sectors and is suitable for demonstrating
backtesting and technical analysis functions.
}
\examples{
data(sample_prices_weekly)
head(sample_prices_weekly)
# Calculate momentum
momentum <- calc_momentum(sample_prices_weekly, lookback = 12)
}
\keyword{datasets}
