% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_sectional.R
\name{calc_sector_relative_indicators}
\alias{calc_sector_relative_indicators}
\title{Calculate Indicators Relative to Sector Average}
\usage{
calc_sector_relative_indicators(
  indicator_df,
  sector_mapping,
  method = c("difference", "ratio", "z-score"),
  benchmark = c("mean", "median"),
  ratio_threshold = 0.01,
  min_sector_size = 2
)
}
\arguments{
\item{indicator_df}{Data frame with Date column and indicator values}

\item{sector_mapping}{Data frame with \code{Symbol} and \code{Sector} columns.}

\item{method}{"difference" (absolute), "ratio" (relative), or "z-score"}

\item{benchmark}{"mean" or "median" sector average}

\item{ratio_threshold}{Minimum denominator for ratio method (default: 0.01)}

\item{min_sector_size}{Minimum stocks per sector (default: 2)}
}
\value{
Data frame with sector-relative values
}
\description{
Measures how each stock's indicator compares to its sector benchmark.
Enables sector-neutral strategies and identifies sector outperformers.
}
\examples{
# Find stocks outperforming their sector
data("sample_prices_weekly")
data("sample_sp500_sectors")
momentum <- calc_momentum(sample_prices_weekly, 12)
relative_momentum <- calc_sector_relative_indicators(
  momentum, sample_sp500_sectors, method = "difference"
)
}
