/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.api;

import com.portfolioeffect.quant.client.api.Portfolio;
import com.portfolioeffect.quant.client.model.ComputeErrorException;
import com.portfolioeffect.quant.client.result.LazyMetric;

public class Metric {
    private LazyMetric metric;

    public Metric(LazyMetric metric) {
        this.metric = metric;
    }

    public boolean hasError() {
        return this.metric.hasError();
    }

    public String getError() {
        return this.metric.getErrorMessage();
    }

    public double[] getValue() throws ComputeErrorException {
        this.checkError();
        return this.metric.getValue();
    }

    public long[] getTime() throws ComputeErrorException {
        this.checkError();
        return this.metric.getTime();
    }

    public long getLastTime() throws ComputeErrorException {
        this.checkError();
        return this.metric.getLastTime();
    }

    public double getLastValue() throws ComputeErrorException {
        this.checkError();
        return this.metric.getLastValue();
    }

    public Portfolio getPortfolio() throws ComputeErrorException {
        this.checkError();
        return new Portfolio(this.metric.getPortfolio("portfolio"));
    }

    public LazyMetric getMetric() {
        return this.metric;
    }

    public void checkError() throws ComputeErrorException {
        if (this.hasError()) {
            throw new ComputeErrorException(this.getError());
        }
    }
}

