/*
 * Decompiled with CFR 0.152.
 */
package org.openfast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.openfast.FieldValue;
import org.openfast.GroupValue;
import org.openfast.template.Sequence;

public class SequenceValue
implements FieldValue {
    private static final long serialVersionUID = 1L;
    private List elements = Collections.EMPTY_LIST;
    private Sequence sequence;

    public SequenceValue(Sequence sequence) {
        if (sequence == null) {
            throw new NullPointerException();
        }
        this.sequence = sequence;
    }

    public int getLength() {
        return this.elements.size();
    }

    public Iterator iterator() {
        return this.elements.iterator();
    }

    public void add(GroupValue value) {
        if (this.elements == Collections.EMPTY_LIST) {
            this.elements = new ArrayList();
        }
        this.elements.add(value);
    }

    public void add(FieldValue[] values) {
        if (this.elements == Collections.EMPTY_LIST) {
            this.elements = new ArrayList();
        }
        this.elements.add(new GroupValue(this.sequence.getGroup(), values));
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof SequenceValue)) {
            return false;
        }
        return this.equals((SequenceValue)other);
    }

    private boolean equals(SequenceValue other) {
        if (this.getLength() != other.getLength()) {
            return false;
        }
        int i = 0;
        while (i < this.getLength()) {
            if (!this.elements.get(i).equals(other.elements.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.elements.hashCode() * 37 + this.sequence.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Iterator iter = this.elements.iterator();
        builder.append("[ ");
        while (iter.hasNext()) {
            GroupValue value = (GroupValue)iter.next();
            builder.append('[').append(value).append("] ");
        }
        builder.append("]");
        return builder.toString();
    }

    public GroupValue get(int index) {
        return (GroupValue)this.elements.get(index);
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public GroupValue[] getValues() {
        return this.elements.toArray(new GroupValue[this.elements.size()]);
    }

    public FieldValue copy() {
        SequenceValue value = new SequenceValue(this.sequence);
        int i = 0;
        while (i < this.elements.size()) {
            value.add((GroupValue)((GroupValue)this.elements.get(i)).copy());
            ++i;
        }
        return value;
    }
}

