/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.portfolio.optimizer;

import com.google.gson.Gson;
import com.portfolioeffect.quant.client.portfolio.Portfolio;
import com.portfolioeffect.quant.client.portfolio.optimizer.ForecastedValues;
import com.portfolioeffect.quant.client.portfolio.optimizer.PortfolioOptimizer;
import com.portfolioeffect.quant.client.result.LazyMetric;
import com.portfolioeffect.quant.client.result.Metric;
import com.portfolioeffect.quant.client.type.MetricsTypeFull;
import com.portfolioeffect.quant.client.util.LinearForecastBuilder;
import com.portfolioeffect.quant.client.util.SimpleLazyMetricBuilder;
import com.portfolioeffect.quant.client.util.SimpleMetricUpdateCallback;
import java.util.ArrayList;
import java.util.HashMap;

public class StrategyOptimizer
extends PortfolioOptimizer {
    private LinearForecastBuilder expectedReturnForecastBuilder;
    private LinearForecastBuilder varianceForecastBuilder;
    private LinearForecastBuilder cumulant3ForecastBuilder;
    private LinearForecastBuilder cumulant4ForecastBuilder;
    private LinearForecastBuilder betaForecastBuilder;
    private String forecastStep = "";
    private ForecastedValues forecastedValue = null;

    public StrategyOptimizer(Portfolio portfolio, double localOptimStopStep, double globalOptimProbability) {
        super(portfolio, localOptimStopStep, globalOptimProbability);
    }

    public StrategyOptimizer(Portfolio portfolio) {
        super(portfolio);
    }

    public void setForecastedValue(ForecastedValues forecastedValue) {
        this.forecastedValue = forecastedValue;
    }

    public ForecastedValues getForecastedValue() {
        return this.forecastedValue;
    }

    @Override
    public LazyMetric getOptimizedPortfolio() throws Exception {
        Metric checkResult;
        this.optimizedPortfolio = new Portfolio(this.portfolio);
        this.resultPortfolio = new Portfolio(this.portfolio);
        SimpleLazyMetricBuilder metricBuilder = new SimpleLazyMetricBuilder();
        try {
            String metric;
            LinearForecastBuilder forecastBuilder;
            LazyMetric lazyMetric;
            String position;
            if (this.forecastStep.equals("")) {
                throw new Exception("forecast step is not set");
            }
            this.optimizedPortfolio.addUserData("expTimeStep", new double[]{Portfolio.parseWindowLength(this.forecastStep)}, new long[]{-1L});
            this.checkAllForecastBuilderSet();
            HashMap<String, String> forecastParams = new HashMap<String, String>();
            forecastParams.put("section", "FORECAST_PARAMS");
            ArrayList<String> metricList = new ArrayList<String>();
            Gson gson = new Gson();
            String[] stringArray = this.portfolio.getSymbols();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                position = stringArray[n2];
                metricBuilder.setMetric(MetricsTypeFull.POSITION_VARIANCE);
                metricBuilder.setWindowLength(this.forecastStep);
                metricBuilder.setPositionName(position);
                lazyMetric = metricBuilder.build(this.optimizedPortfolio, true);
                forecastBuilder = new LinearForecastBuilder(this.varianceForecastBuilder);
                forecastBuilder.setDependentVariable(lazyMetric);
                forecastBuilder.setForecastStep(this.forecastStep);
                metric = forecastBuilder.buildStrRequest();
                metricList.add(metric);
                ++n2;
            }
            String metricValue = gson.toJson(metricList);
            forecastParams.put("positionVariance", metricValue);
            metricList.clear();
            stringArray = this.portfolio.getSymbols();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                position = stringArray[n2];
                metricBuilder.setMetric(MetricsTypeFull.POSITION_CUMULANT3);
                metricBuilder.setWindowLength(this.forecastStep);
                metricBuilder.setPositionName(position);
                lazyMetric = metricBuilder.build(this.optimizedPortfolio, true);
                forecastBuilder = new LinearForecastBuilder(this.cumulant3ForecastBuilder);
                forecastBuilder.setForecastStep(this.forecastStep);
                forecastBuilder.setDependentVariable(lazyMetric);
                forecastBuilder.setTransform("none");
                metric = forecastBuilder.buildStrRequest();
                metricList.add(metric);
                ++n2;
            }
            metricValue = gson.toJson(metricList);
            forecastParams.put("positionCumulant3", metricValue);
            metricList.clear();
            stringArray = this.portfolio.getSymbols();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                position = stringArray[n2];
                metricBuilder.setMetric(MetricsTypeFull.POSITION_CUMULANT4);
                metricBuilder.setWindowLength(this.forecastStep);
                metricBuilder.setPositionName(position);
                lazyMetric = metricBuilder.build(this.optimizedPortfolio, true);
                forecastBuilder = new LinearForecastBuilder(this.cumulant4ForecastBuilder);
                forecastBuilder.setDependentVariable(lazyMetric);
                forecastBuilder.setForecastStep(this.forecastStep);
                forecastBuilder.setTransform("none");
                metric = forecastBuilder.buildStrRequest();
                metricList.add(metric);
                ++n2;
            }
            metricValue = gson.toJson(metricList);
            forecastParams.put("positionCumulant4", metricValue);
            metricList.clear();
            stringArray = this.portfolio.getSymbols();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                position = stringArray[n2];
                metricBuilder.setMetric(MetricsTypeFull.POSITION_BETA);
                metricBuilder.setWindowLength(this.forecastStep);
                metricBuilder.setPositionName(position);
                lazyMetric = metricBuilder.build(this.optimizedPortfolio, true);
                forecastBuilder = new LinearForecastBuilder(this.betaForecastBuilder);
                forecastBuilder.setDependentVariable(lazyMetric);
                forecastBuilder.setForecastStep(this.forecastStep);
                forecastBuilder.setTransform("none");
                metric = forecastBuilder.buildStrRequest();
                metricList.add(metric);
                ++n2;
            }
            metricValue = gson.toJson(metricList);
            forecastParams.put("positionBeta", metricValue);
            metricList.clear();
            stringArray = this.portfolio.getSymbols();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                position = stringArray[n2];
                metricBuilder.setMetric(MetricsTypeFull.POSITION_EXPECTED_RETURN);
                metricBuilder.setWindowLength(this.forecastStep);
                metricBuilder.setPositionName(position);
                lazyMetric = metricBuilder.build(this.optimizedPortfolio, true);
                forecastBuilder = new LinearForecastBuilder(this.expectedReturnForecastBuilder);
                forecastBuilder.setDependentVariable(lazyMetric);
                forecastBuilder.setForecastStep(this.forecastStep);
                forecastBuilder.setTransform("none");
                metric = forecastBuilder.buildStrRequest();
                metricList.add(metric);
                ++n2;
            }
            metricValue = gson.toJson(metricList);
            forecastParams.put("positionExpectedReturn", metricValue);
            metricList.clear();
            metricBuilder.setMetric(MetricsTypeFull.INDEX_EXPECTED_RETURN);
            metricBuilder.setWindowLength(this.forecastStep);
            lazyMetric = metricBuilder.build(this.optimizedPortfolio, true);
            forecastBuilder = new LinearForecastBuilder(this.expectedReturnForecastBuilder);
            forecastBuilder.setForecastStep(this.forecastStep);
            forecastBuilder.setDependentVariable(lazyMetric);
            metricValue = forecastBuilder.buildStrRequest();
            forecastParams.put("indexExpectedReturn", metricValue);
            metricBuilder.setMetric(MetricsTypeFull.INDEX_VARIANCE);
            metricBuilder.setWindowLength(this.forecastStep);
            lazyMetric = metricBuilder.build(this.optimizedPortfolio, true);
            forecastBuilder = new LinearForecastBuilder(this.varianceForecastBuilder);
            forecastBuilder.setForecastStep(this.forecastStep);
            forecastBuilder.setDependentVariable(lazyMetric);
            metricValue = forecastBuilder.buildStrRequest();
            forecastParams.put("indexVariance", metricValue);
            metricBuilder.setMetric(MetricsTypeFull.INDEX_CUMULANT3);
            metricBuilder.setWindowLength(this.forecastStep);
            lazyMetric = metricBuilder.build(this.optimizedPortfolio, true);
            forecastBuilder = new LinearForecastBuilder(this.cumulant3ForecastBuilder);
            forecastBuilder.setForecastStep(this.forecastStep);
            forecastBuilder.setDependentVariable(lazyMetric);
            forecastBuilder.setTransform("none");
            metricValue = forecastBuilder.buildStrRequest();
            forecastParams.put("indexCumulant3", metricValue);
            metricBuilder.setMetric(MetricsTypeFull.INDEX_CUMULANT4);
            metricBuilder.setWindowLength(this.forecastStep);
            lazyMetric = metricBuilder.build(this.optimizedPortfolio, true);
            forecastBuilder = new LinearForecastBuilder(this.cumulant4ForecastBuilder);
            forecastBuilder.setForecastStep(this.forecastStep);
            forecastBuilder.setDependentVariable(lazyMetric);
            forecastBuilder.setTransform("none");
            metricValue = forecastBuilder.buildStrRequest();
            forecastParams.put("indexCumulant4", metricValue);
            this.paramsBuffer.add(forecastParams);
            this.optimizationInit();
        }
        catch (Exception e1) {
            return new LazyMetric(e1.getMessage());
        }
        if (this.forecastedValue != null && (checkResult = this.forecastedValue.addToPortfolio(this.optimizedPortfolio)).hasError()) {
            return new LazyMetric(checkResult.getErrorMessage());
        }
        return this.makeOptimization();
    }

    private void checkAllForecastBuilderSet() throws Exception {
        if (this.expectedReturnForecastBuilder == null) {
            throw new Exception("forecast bulider for expected return is not set");
        }
        if (this.varianceForecastBuilder == null) {
            throw new Exception("forecast bulider for variance is not set");
        }
        if (this.cumulant3ForecastBuilder == null) {
            throw new Exception("forecast bulider for cumulant3 is not set");
        }
        if (this.cumulant4ForecastBuilder == null) {
            throw new Exception("forecast bulider for cumulant4 is not set");
        }
        if (this.betaForecastBuilder == null) {
            throw new Exception("forecast bulider for beta is not set");
        }
    }

    @Override
    public LazyMetric getOptimizedPortfolioStream() throws Exception {
        Metric checkResult;
        this.optimizedPortfolio = new Portfolio(this.portfolio);
        this.resultPortfolio = new Portfolio(this.portfolio);
        this.optimizedPortfolio.initStreamSingleMetric(new SimpleMetricUpdateCallback(){

            @Override
            public void onDataRefresh(float[] data, long[] time) {
                int nSymbols = StrategyOptimizer.this.resultPortfolio.getSymbolNamesList().size();
                int len = 0;
                int i = 0;
                while (i < time.length) {
                    int k = 0;
                    while (k < nSymbols) {
                        StrategyOptimizer.this.resultPortfolio.setStreamQuantity(StrategyOptimizer.this.resultPortfolio.getSymbolNamesList().get(k), (int)data[len], time[i]);
                        ++len;
                        ++k;
                    }
                    ++i;
                }
            }
        });
        try {
            HashMap<String, String> forecastParams = new HashMap<String, String>();
            forecastParams.put("section", "FORECAST_PARAMS");
            this.paramsBuffer.add(forecastParams);
            this.optimizationInit();
        }
        catch (Exception e1) {
            return new LazyMetric(e1.getMessage());
        }
        if (this.forecastedValue != null && (checkResult = this.forecastedValue.addToPortfolio(this.optimizedPortfolio)).hasError()) {
            return new LazyMetric(checkResult.getErrorMessage());
        }
        return this.makeOptimization();
    }

    public LinearForecastBuilder getExpectedReturnForecastBuilder() {
        return this.expectedReturnForecastBuilder;
    }

    public void setExpectedReturnForecastBuilder(LinearForecastBuilder expectedReturnForecastBuilder) {
        this.expectedReturnForecastBuilder = expectedReturnForecastBuilder;
    }

    public LinearForecastBuilder getVarianceForecastBuilder() {
        return this.varianceForecastBuilder;
    }

    public void setVarianceForecastBuilder(LinearForecastBuilder varianceForecastBuilder) {
        this.varianceForecastBuilder = varianceForecastBuilder;
    }

    public LinearForecastBuilder getCumulant3ForecastBuilder() {
        return this.cumulant3ForecastBuilder;
    }

    public void setCumulant3ForecastBuilder(LinearForecastBuilder cumulant3ForecastBuilder) {
        this.cumulant3ForecastBuilder = cumulant3ForecastBuilder;
    }

    public LinearForecastBuilder getCumulant4ForecastBuilder() {
        return this.cumulant4ForecastBuilder;
    }

    public void setCumulant4ForecastBuilder(LinearForecastBuilder cumulant4ForecastBuilder) {
        this.cumulant4ForecastBuilder = cumulant4ForecastBuilder;
    }

    public LinearForecastBuilder getBetaForecastBuilder() {
        return this.betaForecastBuilder;
    }

    public void setBetaForecastBuilder(LinearForecastBuilder betaForecastBuilder) {
        this.betaForecastBuilder = betaForecastBuilder;
    }

    public void setForecastBuilder(LinearForecastBuilder forecastBuilder) {
        if (this.expectedReturnForecastBuilder == null) {
            this.expectedReturnForecastBuilder = forecastBuilder;
        }
        if (this.varianceForecastBuilder == null) {
            this.varianceForecastBuilder = forecastBuilder;
        }
        if (this.cumulant3ForecastBuilder == null) {
            this.cumulant3ForecastBuilder = forecastBuilder;
        }
        if (this.cumulant4ForecastBuilder == null) {
            this.cumulant4ForecastBuilder = forecastBuilder;
        }
        if (this.betaForecastBuilder == null) {
            this.betaForecastBuilder = forecastBuilder;
        }
    }

    public String getForecastStep() {
        return this.forecastStep;
    }

    public void setForecastStep(String forecastTimeStep) {
        this.forecastStep = forecastTimeStep;
    }
}

