/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.session.template.exchange;

import org.openfast.FieldValue;
import org.openfast.GroupValue;
import org.openfast.Node;
import org.openfast.QName;
import org.openfast.error.FastConstants;
import org.openfast.session.SessionControlProtocol_1_1;
import org.openfast.session.template.exchange.ConversionContext;
import org.openfast.session.template.exchange.ScalarConverter;
import org.openfast.template.Field;
import org.openfast.template.Group;
import org.openfast.template.Scalar;
import org.openfast.template.TemplateRegistry;
import org.openfast.template.type.Type;
import org.openfast.util.Util;

public class VariableLengthInstructionConverter
extends ScalarConverter {
    public Field convert(GroupValue fieldDef, TemplateRegistry templateRegistry, ConversionContext context) {
        Scalar scalar = (Scalar)super.convert(fieldDef, templateRegistry, context);
        if (fieldDef.isDefined("Length")) {
            GroupValue lengthDef = fieldDef.getGroup("Length");
            String lengthName = lengthDef.getString("Name");
            String lengthNs = "";
            if (lengthDef.isDefined("Ns")) {
                lengthNs = lengthDef.getString("Ns");
            }
            String id = lengthDef.getString("AuxId");
            scalar.addNode(Util.createLength(new QName(lengthName, lengthNs), id));
        }
        return scalar;
    }

    public GroupValue convert(Field field, ConversionContext context) {
        Scalar scalar = (Scalar)field;
        GroupValue fieldDef = super.convert(field, context);
        if (scalar.hasChild(FastConstants.LENGTH_FIELD)) {
            Node lengthNode = (Node)scalar.getChildren(FastConstants.LENGTH_FIELD).get(0);
            GroupValue lengthDef = new GroupValue(fieldDef.getGroup().getGroup("Length"));
            lengthDef.setString("Ns", lengthNode.getAttribute(FastConstants.LENGTH_NS_ATTR));
            lengthDef.setString("Name", lengthNode.getAttribute(FastConstants.LENGTH_NAME_ATTR));
            if (lengthNode.hasAttribute(FastConstants.LENGTH_ID_ATTR)) {
                lengthDef.setString("AuxId", lengthNode.getAttribute(FastConstants.LENGTH_ID_ATTR));
            }
            fieldDef.setFieldValue("Length", (FieldValue)lengthDef);
        }
        return fieldDef;
    }

    public boolean shouldConvert(Field field) {
        if (!field.getClass().equals(Scalar.class)) {
            return false;
        }
        Type type = ((Scalar)field).getType();
        return type.equals(Type.BYTE_VECTOR) || type.equals(Type.UNICODE);
    }

    public Group[] getTemplateExchangeTemplates() {
        return new Group[]{SessionControlProtocol_1_1.BYTE_VECTOR_INSTR, SessionControlProtocol_1_1.UNICODE_INSTR};
    }
}

