/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.type.codec;

import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.openfast.DateValue;
import org.openfast.Global;
import org.openfast.ScalarValue;
import org.openfast.StringValue;
import org.openfast.error.FastConstants;
import org.openfast.template.type.codec.TypeCodec;

public class DateString
extends TypeCodec {
    private static final long serialVersionUID = 1L;
    private final DateFormat formatter;

    public DateString(String format) {
        this.formatter = new SimpleDateFormat(format);
        this.formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public ScalarValue decode(InputStream in) {
        try {
            return new DateValue(this.formatter.parse(TypeCodec.ASCII.decode(in).toString()));
        }
        catch (ParseException e) {
            Global.handleError(FastConstants.PARSE_ERROR, "", e);
            return null;
        }
    }

    public byte[] encodeValue(ScalarValue value) {
        return TypeCodec.ASCII.encode(new StringValue(this.formatter.format(((DateValue)value).value)));
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }
}

