% Generated by roxygen2 (4.0.1): do not edit by hand
\name{ed_laplace_ofv}
\alias{ed_laplace_ofv}
\title{Evaluate the expectation of determinant the Fisher Information Matrix (FIM)
using the Laplace approximation.}
\usage{
ed_laplace_ofv(model_switch, groupsize, ni, xtopto, xopto, aopto, bpopdescr,
  ddescr, covd, sigma, docc, poped.db, method = 1, return_gradient = FALSE,
  optxt = poped.db$optsw[2], opta = poped.db$optsw[4], x = c())
}
\arguments{
\item{x}{The design parameters to compute the gradient on.}

\item{xtopto}{the sampling times}

\item{xopto}{the discrete design variables}

\item{optxt}{If sampling times are optimized}

\item{opta}{If continuous design variables are optimized}

\item{aopto}{the continuous design variables}

\item{method}{If 0 then use an optimization routine translated from poped code written in MATLAB to
optimize the parameters in the Laplace approximation.  If 1 then use \code{\link{optim}} to compute both
k and the hessian of k (see Dodds et al, JPP, 2005 for more information). If 2 then use \code{\link{fdHess}}
to compute the hessian.}

\item{return_gradient}{Should the gradient be returned.}

\item{model_switch}{A matrix that is the same size as xt, specifying which model each sample belongs to.}

\item{groupsize}{A vector of the numer of individuals in each group.}

\item{ni}{A vector of the number of samples in each group.}

\item{poped.db}{A PopED database.}

\item{covd}{Matrix defining the covariances of the IIV variances. Set to zero if not defined.}

\item{sigma}{Matrix defining the variances can covariances of the residual variability terms of the model.
can also just supply the diagnonal parameter values (variances) as a \code{c()}.}

\item{docc}{Matrix defining the IOV, the IOV variances and the IOV distribution}

\item{bpopdescr}{Matrix defining the fixed effects, per row (row number = parameter_number) we should have:
\itemize{
\item column 1 the type of the distribution for E-family designs (0 = Fixed, 1 = Normal, 2 = Uniform,
 3 = User Defined Distribution, 4 = lognormal and 5 = truncated normal)
\item column 2  defines the mean.
\item column 3 defines the variance of the distribution (or length of uniform distribution).
}}

\item{ddescr}{Matrix defining the diagnonals of the IIV (same logic as for the \code{bpopdescr}).}
}
\value{
The FIM and the hessian of the FIM.
}
\description{
Compute the expectation of the \code{det(FIM)} using the Laplace
approximation to the expectation. Computations are made based on the model,
parameters, distributions of parameter uncertainty, design and methods
defined in the PopED database or as arguments to the funciton.
}
\details{
This computation follows the method outlined in Dodds et al,
"Robust Population Pharmacokinetic Experiment Design" JPP, 2005, equation 16.

Typically this function will not be run by the user.  Instead use \code{\link{evaluate.e.ofv.fim}}.
}
\examples{
## Warfarin example from software comparison in:
## Nyberg et al., "Methods and software tools for design evaluation 
##   for population pharmacokinetics-pharmacodynamics studies", 
##   Br. J. Clin. Pharm., 2014. 

## Optimization using an additive + proportional reidual error to 
##   avoid sample times at very low concentrations (time 0 or very late samoples).
library(PopED)

## find the parameters that are needed to define from the structural model
ff.PK.1.comp.oral.sd.CL

## -- parameter definition function 
## -- names match parameters in function ff
sfg <- function(x,a,bpop,b,bocc){
  parameters=c(CL=bpop[1]*exp(b[1]),
               V=bpop[2]*exp(b[2]),
               KA=bpop[3]*exp(b[3]),
               Favail=bpop[4],
               DOSE=a[1])
  return(parameters) 
}

######################
# Normal distribution
######################
bpop_vals <- c(CL=0.15, V=8, KA=1.0, Favail=1)
bpop_vals_ed_n <- cbind(ones(length(bpop_vals),1)*1, # normal distribution
                        bpop_vals,
                        ones(length(bpop_vals),1)*(bpop_vals*0.1)^2) # 10\% of bpop value
bpop_vals_ed_n["Favail",]  <- c(0,1,0)
bpop_vals_ed_n

## -- Define initial design  and design space
poped.db.n <- create.poped.database(ff_file="ff.PK.1.comp.oral.sd.CL",
                                    fg_file="sfg",
                                    fError_file="feps.add.prop",
                                    bpop=bpop_vals_ed_n, 
                                    notfixed_bpop=c(1,1,1,0),
                                    d=c(CL=0.07, V=0.02, KA=0.6), 
                                    sigma=c(0.01,0.25),
                                    groupsize=32,
                                    xt=c( 0.5,1,2,6,24,36,72,120),
                                    minxt=0,
                                    maxxt=120,
                                    a=70,
                                    mina=0,
                                    maxa=100)


## ED evaluate using LaPlace approximation 
tic()
output <- evaluate.e.ofv.fim(poped.db.n,use_laplace=TRUE)
toc()
output$E_ofv

\dontrun{
  
  
  ## expected value (roughly)
  tic()
  e_ofv_mc_n <- evaluate.e.ofv.fim(poped.db.n,ED_samp_size=500)
  toc()
  e_ofv_mc_n$E_ofv
  
  
  ## Using ed_laplce_ofv directly
  ed_laplace_ofv(model_switch=poped.db.n$global_model_switch,
                 groupsize=poped.db.n$groupsize,
                 ni=poped.db.n$gni,
                 xtopto=poped.db.n$gxt,
                 xopto=poped.db.n$gx,
                 aopto=poped.db.n$ga,
                 bpopdescr=poped.db.n$gbpop,
                 ddescr=poped.db.n$gd,
                 covd=poped.db.n$covd,
                 sigma=poped.db.n$sigma,
                 docc=poped.db.n$docc, 
                 poped.db.n)
  
  
  ######################
  # Log-normal distribution
  ######################
  
  # Adding 10\% log-normal Uncertainty to fixed effects (not Favail)
  bpop_vals <- c(CL=0.15, V=8, KA=1.0, Favail=1)
  bpop_vals_ed_ln <- cbind(ones(length(bpop_vals),1)*4, # log-normal distribution
                           bpop_vals,
                           ones(length(bpop_vals),1)*(bpop_vals*0.1)^2) # 10\% of bpop value
  bpop_vals_ed_ln["Favail",]  <- c(0,1,0)
  bpop_vals_ed_ln
  
  ## -- Define initial design  and design space
  poped.db.ln <- create.poped.database(ff_file="ff.PK.1.comp.oral.sd.CL",
                                       fg_file="sfg",
                                       fError_file="feps.add.prop",
                                       bpop=bpop_vals_ed_ln, 
                                       notfixed_bpop=c(1,1,1,0),
                                       d=c(CL=0.07, V=0.02, KA=0.6), 
                                       sigma=c(0.01,0.25),
                                       groupsize=32,
                                       xt=c( 0.5,1,2,6,24,36,72,120),
                                       minxt=0,
                                       maxxt=120,
                                       a=70,
                                       mina=0,
                                       maxa=100)
  
  
  
  ## ED evaluate using LaPlace approximation 
  tic()
  output <- evaluate.e.ofv.fim(poped.db.ln,use_laplace=TRUE)
  toc()
  output$E_ofv
  
  ## expected value (roughly)
  tic()
  e_ofv_mc_ln <- evaluate.e.ofv.fim(poped.db.ln,ED_samp_size=500)[["E_ofv"]]
  toc()
  e_ofv_mc_ln
  
  ## Using ed_laplce_ofv directly
  ed_laplace_ofv(model_switch=poped.db.ln$global_model_switch,
                 groupsize=poped.db.ln$groupsize,
                 ni=poped.db.ln$gni,
                 xtopto=poped.db.ln$gxt,
                 xopto=poped.db.ln$gx,
                 aopto=poped.db.ln$ga,
                 bpopdescr=poped.db.ln$gbpop,
                 ddescr=poped.db.ln$gd,
                 covd=poped.db.ln$covd,
                 sigma=poped.db.ln$sigma,
                 docc=poped.db.ln$docc, 
                 poped.db.ln)
  
  
  
  
}

}
\seealso{
Other E-family: \code{\link{calc_ofv_and_fim}};
  \code{\link{ed_mftot}}; \code{\link{evaluate.e.ofv.fim}}

Other FIM: \code{\link{LinMatrixH}};
  \code{\link{LinMatrixLH}}; \code{\link{LinMatrixL_occ}};
  \code{\link{calc_ofv_and_fim}}; \code{\link{ed_mftot}};
  \code{\link{evaluate.e.ofv.fim}};
  \code{\link{evaluate.fim}}; \code{\link{gradf_eps}};
  \code{\link{mf3}}; \code{\link{mf5}}; \code{\link{mf6}};
  \code{\link{mf7}}; \code{\link{mf8}};
  \code{\link{mftot0}}; \code{\link{mftot1}};
  \code{\link{mftot2}}; \code{\link{mftot3}};
  \code{\link{mftot4}}; \code{\link{mftot5}};
  \code{\link{mftot6}}; \code{\link{mftot7}};
  \code{\link{mftot}}; \code{\link{mf}};
  \code{\link{ofv_criterion}}; \code{\link{ofv_fim}}
}

