% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_clean.R
\name{pp_clean}
\alias{pp_clean}
\title{Tidy a dataset with a "long" policy portfolio structure}
\usage{
pp_clean(
  d,
  Sector = NULL,
  Country.name = "Country",
  Year.name = "Year",
  Instrument.name = "Instrument",
  Target.name = "Target",
  coding.category.name = "Coding category",
  coding.category = 2,
  Direction.name = "Direction",
  directions = c(0, 1, -1),
  associated.vars = NULL,
  debug = FALSE
)
}
\arguments{
\item{d}{Data frame in an uncleaned and untidy structure containing data from a policy portfolio.}

\item{Sector}{Character vector with the Sector of the dataset.}

\item{Country.name}{Character vector of length one with the name of the variable that contains the country name.}

\item{Year.name}{Character vector of length one with the name of the variable that contains the year.}

\item{Instrument.name}{Character vector of length one with the name of the variable that contains the instruments.}

\item{Target.name}{Character vector of length one with the name of the variable that contains the targets.}

\item{coding.category.name}{Character vector of length one with the name of the variable that contains the coding category.}

\item{coding.category}{Numerical value with the level of the category that captures the combination of instrument and target.}

\item{Direction.name}{Character vector of length one with the name of the variable that contains the direction of the policy change.}

\item{directions}{Numerical vector with the numeric values of the direction of the policy changes, namely "Status quo", "Expansion" and "Dismantling". Defaults to, 0, 1 and -1, respectively.}

\item{associated.vars}{Character vector indicating variables that contain characteristics of the policy space.}

\item{debug}{Logical value. When TRUE, print more verbose information about the cleaning process.}
}
\value{
D Data frame in a tidy format with the following columns: "Country", "Sector", "Year", "Instrument", "Target" and "covered". "covered" is a binary identificator of whether the portfolio space is covered by policy intervention (1) or not (0). The remaining columns identify the case. Notice that "Year" is a numeric value, while the remaining 4 case identifiers are factors.
}
\description{
Clean a policy portfolio dataset into a tidy object.
}
\examples{
\dontrun{
X <- read.table("raw_data.csv", header = TRUE)
D <- pp_clean(X, Sector = "Education")

# Now 'D' is a tidy dataset suitable for being used in the context of the 'PolicyPortfolio' package.
}
}
