% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intModel.R
\name{intModel}
\alias{intModel}
\title{\emph{intModel}: Function used to initialize the integrated species distribution model.}
\usage{
intModel(
  ...,
  spatialCovariates = NULL,
  Coordinates,
  Projection,
  Mesh,
  IPS = NULL,
  Boundary = NULL,
  speciesSpatial = "copy",
  markNames = NULL,
  markFamily = NULL,
  pointCovariates = NULL,
  pointsIntercept = TRUE,
  marksIntercept = TRUE,
  Offset = NULL,
  pointsSpatial = "shared",
  marksSpatial = TRUE,
  responseCounts = "counts",
  responsePA = "present",
  trialsPA = NULL,
  trialsMarks = NULL,
  speciesName = NULL,
  temporalName = NULL,
  temporalModel = list(model = "ar1"),
  copyModel = list(beta = list(fixed = FALSE))
)
}
\arguments{
\item{...}{The datasets to be used in the model. May come as either \code{sf}, \code{data.frame} or \code{SpatialPoints*} objects, or as a list of objects with these classes. The classes of the datasets do not necessarily need to be standardized, however the variable names within them often have to be.}

\item{spatialCovariates}{The spatial covariates used in the model. These covariates must be measured at every location (pixel) in the study area, and must be a \code{Raster*}, \code{SpatialPixelsDataFrame} or \code{SpatialRaster} object. Can be either \code{numeric}, \code{factor} or \code{character} data.}

\item{Coordinates}{A vector of length 2 containing the names (class \code{character}) of the coordinate variables used in the model.}

\item{Projection}{The coordinate reference system used by both the spatial points and spatial covariates. Must be of class \code{character}.}

\item{Mesh}{An \code{inla.mesh} object required for the spatial random fields and the integration points in the model (see \code{\link[INLA]{inla.mesh.2d}} from the \pkg{INLA} package for more details).}

\item{IPS}{The integration points to be used in the model (that is, the points on the map where the intensity of the model is calculated). See \code{\link[inlabru]{ipoints}} from the \pkg{inlabru} package for more details regarding these points; however defaults to \code{NULL} which will create integration points from the \code{Mesh} object.}

\item{Boundary}{A \code{sf} object of the study area. If not missing, this object is used to help create the integration points.}

\item{speciesSpatial}{Argument to specify if each species should have their own spatial effect with different hyperparameters to be estimated, of if a the field's should be estimated using \pkg{INLA}'s "copy" feature. Possible values include: \code{'individual'}, \code{'copy'} or \code{NULL} if no species-specific spatial effects should be estimated.}

\item{markNames}{A vector with the mark names (class \code{character}) to be included in the integrated model. Marks are variables which are used to describe the individual points in the model (for example, in the field of ecology the size of the species or its feeding type could be considered). Defaults to \code{NULL}, however if this argument is non-\code{NULL}, the model run will become a marked point process. The marks must be included in the same data object as the points.}

\item{markFamily}{A vector with the statistical families (class \code{character}) assumed for the marks. Must be the same length as markNames, and the position of the mark in the vector \code{markName} is associated with the position of the family in \code{markFamily}. Defaults to \code{NULL} which assigns each mark as "Gaussian".}

\item{pointCovariates}{The non-spatial covariates to be included in the integrated model (for example, in the field of ecology the distance to the nearest road or time spent sampling could be considered). These covariates must be included in the same data object as the points.}

\item{pointsIntercept}{Logical argument: should the points be modeled with intercepts. Defaults to \code{TRUE}.}

\item{marksIntercept}{Logical argument: should the marks be modeled with intercepts. Defaults to \code{TRUE}.}

\item{Offset}{Name of the offset variable (class \code{character}) in the datasets. Defaults to \code{NULL}; if the argument is non-\code{NULL}, the variable name needs to be standardized across datasets (but does not need to be included in all datasets). The offset variable will be transformed onto the log-scale in the integrated model.}

\item{pointsSpatial}{Argument to determine whether the spatial field is shared between the datasets, or if each dataset has its own unique spatial field. The datasets may share a spatial field with \pkg{INLA}'s "copy" feature if the argument is set to \code{copy}. May take on the values: \code{"shared"}, \code{"individual"}, \code{"copy"} or \code{NULL} if no spatial field is required for the model. Defaults to \code{"shared"}.}

\item{marksSpatial}{Logical argument: should the marks have their own spatial field. Defaults to \code{TRUE}.}

\item{responseCounts}{Name of the response variable in the counts/abundance datasets. This variable name needs to be standardized across all counts datasets used in the integrated model. Defaults to \code{'counts'}.}

\item{responsePA}{Name of the response variable (class \code{character}) in the presence absence/detection non-detection datasets. This variable name needs to be standardized across all present absence datasets. Defaults to \code{'present'}.}

\item{trialsPA}{Name of the trials response variable (class \code{character}) for the presence absence datasets. Defaults to \code{NULL}.}

\item{trialsMarks}{Name of the trials response variable (class \code{character}) for the binomial marks (if included). Defaults to \code{NULL}.}

\item{speciesName}{Name of the species variable name (class \code{character}). Specifying this argument turns the model into a stacked species distribution model, and calculates covariate values for the individual species, as well as a species group model in the shared spatial field. Defaults to \code{NULL}}

\item{temporalName}{Name of the temporal variable (class \code{character}) in the model. This variable is required to be in all the datasets. Defaults to \code{NULL}.}

\item{temporalModel}{List of model specifications given to the control.group argument in the time effect component. Defaults to \code{list(model = 'ar1')}; see \code{\link[INLA]{control.group}} from the \pkg{INLA} package for more details.}

\item{copyModel}{List of model specifications given to the hyper parameters for the  \code{"copy"} model. Defaults to \code{list(beta = list(fixed = FALSE))}.}
}
\value{
A \code{\link{dataSDM}} object (class \code{R6}). Use \code{?dataSDM} to get a comprehensive description of the slot functions associated with this object.
}
\description{
This function is used to create an object containing all the data, metadata and relevant components required for the integrated species distribution model and \pkg{INLA} to work.
As a result, the arguments associated with this function are predominantly related to describing variable names within the datasets that are relevant, and arguments related to what terms should be included in the formula for the integrated model. The output of this function is an \code{R6} object, and so there are a variety of public methods within the output of this function which can be used to further specify the model (see \code{?dataSDM} for a comprehensive description of these public methods).
}
\note{
The idea with this function is to describe the full model: that is, all the covariates and spatial effects will appear in all the formulas for the datasets and species.
If some of these terms should not be included in certain observation models in the integrated model, they can be thinned out using the \code{.$updateFormula} function.
Note: the point covariate and mark terms will only be included in the formulas for where they are present in a given dataset, and so these terms do not need to be thinned out if they are not required by certain observation models.
}
\examples{

 if (requireNamespace('INLA')) {
   
 #Get Data
 data("SolitaryTinamou")
 proj <- "+proj=longlat +ellps=WGS84"
 data <- SolitaryTinamou$datasets
 mesh <- SolitaryTinamou$mesh
 mesh$crs <- proj
 
 #Set base model up
 baseModel <- intModel(data, Mesh = mesh, Coordinates = c('X', 'Y'),
                             Projection = proj, responsePA = 'Present')
 
 #Print summary
 baseModel
 
 #Set up model with dataset specific spatial fields
 
 indSpat <- intModel(data, Mesh = mesh, Coordinates = c('X', 'Y'),
                     Projection = proj, pointsSpatial = 'individual', responsePA = 'Present')
                     
 #Model with offset variable
 offSet <- intModel(data, Mesh = mesh, Coordinates = c('X', 'Y'),
                     Projection = proj, Offset = 'area', responsePA = 'Present')
                     
 #Assume area as a mark
 markModel <- intModel(data, Mesh = mesh, Coordinates = c('X', 'Y'),
                     Projection = proj, markNames = 'area', markFamily = 'gamma',
                     responsePA = 'Present')
                      
 }

}
