% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEX_volcano.R
\name{GEX_volcano}
\alias{GEX_volcano}
\title{Plots a volcano plot from the output of the FindMarkers function from the Seurat package or the GEX_cluster_genes function alternatively.}
\usage{
GEX_volcano(
  DEGs.input,
  input.type,
  condition.1,
  condition.2,
  explicit.title,
  RP.MT.filter,
  color.p.threshold,
  color.log.threshold,
  label.p.threshold,
  label.logfc.threshold,
  n.label.up,
  n.label.down,
  by.logFC,
  maximum.overlaps,
  plot.adj.pvalue
)
}
\arguments{
\item{DEGs.input}{Either output data frame from the FindMarkers function from the Seurat package or GEX_cluster_genes list output.}

\item{input.type}{Character specifing the input type as either "findmarkers" or "cluster.genes". Defaults to "cluster.genes"}

\item{condition.1}{either character or integer specifying ident.1 that was used in the FindMarkers function from the Seurat package. Should be left empty when using the GEX_cluster_genes output.}

\item{condition.2}{either character or integer specifying ident.2 that was used in the FindMarkers function from the Seurat package. Should be left empty when using the GEX_cluster_genes output.}

\item{explicit.title}{logical specifying whether the title should include logFC information for each condition.}

\item{RP.MT.filter}{Boolean. Defaults to TRUE. Whether to exclude ribosomal and mitochondrial genes.}

\item{color.p.threshold}{numeric specifying the adjusted p-value threshold for geom_points to be colored. Default is set to 0.01.}

\item{color.log.threshold}{numeric specifying the absolute logFC threshold for geom_points to be colored. Default is set to 0.25.}

\item{label.p.threshold}{numeric specifying the adjusted p-value threshold for genes to be labeled via geom_text_repel. Default is set to 0.001.}

\item{label.logfc.threshold}{numeric specifying the absolute logFC threshold for genes to be labeled via geom_text_repel. Default is set to 0.75.}

\item{n.label.up}{numeric specifying the number of top upregulated genes to be labeled via geom_text_repel. Genes will be ordered by adjusted p-value. Overrides the "label.p.threshold" and "label.logfc.threshold" parameters.}

\item{n.label.down}{numeric specifying the number of top downregulated genes to be labeled via geom_text_repel. Genes will be ordered by adjusted p-value. Overrides the "label.p.threshold" and "label.logfc.threshold" parameters.}

\item{by.logFC}{logical. If set to TRUE n.label.up and n.label.down will label genes ordered by logFC instead of adjusted p-value.}

\item{maximum.overlaps}{integer specifying removal of labels with too many overlaps. Default is set to Inf.}

\item{plot.adj.pvalue}{logical specifying whether adjusted p-value should by plotted on the y-axis.}
}
\value{
Returns a volcano plot from the output of the FindMarkers function from the Seurat package, which is a ggplot object that can be modified or plotted. Infinite p-values are set defined value of the highest -log(p) + 100.
}
\description{
Plots a volcano plot from the output of the FindMarkers function from the Seurat package or the GEX_cluster_genes function alternatively.
}
\examples{
\dontrun{
#using the findmarkers.output
GEX_volcano(findmarkers.output = FindMarkers.Output
, condition.1 = "cluster1", condition.2 = "cluster2"
, maximum.overlaps = 20)

GEX_volcano(findmarkers.output = FindMarkers.Output
, condition.1 = "cluster1", condition.2 = "cluster2"
, n.label.up = 50, n.label.down = 20)

#using the GEX_cluster_genes output
GEX_volcano(findmarkers.output = GEX_cluster_genes.Output
, cluster.genes.output =TRUE)
}
}
