% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection.R
\name{penalty_BirgeMassart_shape2}
\alias{penalty_BirgeMassart_shape2}
\title{Penalty function type Birgé-Massart 2}
\usage{
penalty_BirgeMassart_shape2(K, p, model_complexity, C = 2.5)
}
\arguments{
\item{K}{the number of shifts}

\item{p}{the dimension of the data}

\item{model_complexity}{the complexity of the set of models with dimention K.}

\item{C}{a non-negative constant. Default is 2.5 
(as suggested in Lebarbier 2005)}
}
\value{
value of the penalty.
}
\description{
\code{penalty_BirgeMassart_shape2} is the penalty shape defined by : 
pen_shape = C*K_try + log(model_complexity).
It dominates the penalty defined by \code{penalty_BirgeMassart_shape1}.
}
\details{
See Birge Massart (2001).
Must be applied to least-square crierion.
This penalty should be calibrated using the slope heuristic.
}
\seealso{
\code{\link{penalty_BirgeMassart_shape1}},
\code{\link{penalty_BaraudGiraudHuet_likelihood}}
}
\keyword{internal}
