% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/PharmacoSetClass.R
\name{subsetTo}
\alias{subsetTo}
\title{A function to subset a PharmacoSet to data containing only specified drugs, cells and genes}
\usage{
subsetTo(pSet, cells = NULL, drugs = NULL, molecular.data.cells = NULL,
  keep.controls = TRUE, ...)
}
\arguments{
\item{pSet}{A \code{PharmacoSet} to be subsetted}

\item{cells}{A list or vector of cell names as used in the dataset to which
the object will be subsetted. If left blank, then all cells will be left in
the dataset.}

\item{drugs}{A list or vector of drug names as used in the dataset to which
the object will be subsetted. If left blank, then all drugs will be left in
the dataset.}

\item{molecular.data.cells}{A list or vector of cell names to keep in the
molecular data}

\item{keep.controls}{If the dataset has perturbation type experiments, should
the controls be kept in the dataset? Defaults to true.}

\item{...}{Other arguments passed by other function within the package}
}
\value{
A PharmacoSet with only the selected drugs and cells
}
\description{
This is the prefered method of subsetting a PharmacoSet. This function allows
abstraction of the data to the level of biologically relevant objects: drugs,
genes and cells. The function will automatically go through all of the
combined data in the PharmacoSet and ensure only the requested drugs, genes
and cell lines are found in any of the slots. This allows quickly picking out
all the experiments for a drug or cell of interest, as well removes the need
to keep track of all the metadata conventions between different datasets.
}
\examples{
data(CCLEsmall)
CCLEdrugs  <- drugNames(CCLEsmall)
CCLEcells <- cellNames(CCLEsmall)
PSet <- subsetTo(CCLEsmall,drugs = CCLEdrugs[1], cells = CCLEcells[1])
PSet
}

