% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_docs.R
\name{animals}
\alias{animals}
\title{Returns adoptable animal data from Petfinder based on specified criteria.}
\usage{
animals(animal_id = NULL, animal_type = NULL, breed = NULL,
  size = NULL, gender = NULL, age = NULL, color = NULL,
  coat = NULL, status = NULL, name = NULL, organization_id = NULL,
  location = NULL, distance = NULL, sort = NULL, pages = 1,
  results_per_page = 20, return_df = FALSE)
}
\arguments{
\item{animal_id}{Integer or vector or list of integers representing animal IDs obtained from Petfinder. 
When animal_id is specified, the other function parameters are overridden. If animal_id is not specified, 
a search of animals on Petfinder matching given criteria is performed.}

\item{animal_type}{Character vector representing desired animal type to search. Must be one of 'dog', 'cat', 
'rabbit', 'small-furry', 'horse', 'bird', 'scales-fins-other', or 'barnyard'.}

\item{breed}{Character vector or vector or list of character strings of desired animal type breed to search. 
Available animal breeds in the Petfinder database can be found using the :code:`breeds()` method.}

\item{size}{Character vector or vector or list of character strings of desired animal sizes to return. 
The specified size(s) must be one of 'small', 'medium', 'large', or 'xlarge'.}

\item{gender}{Character vector or vector or list of strings representing animal genders to return. 
Must be of 'male', 'female', or 'unknown'.}

\item{age}{Character or vector or list of strings specifying animal age(s) to return from search. Must be 
of 'baby', 'young', 'adult', 'senior'.}

\item{color}{String representing specified animal 'color' to search. Colors for each available animal type in the 
Petfinder database can be found using the animal_types() method.}

\item{coat}{Desired coat(s) to return. Must be of 'short', 'medium', 'long', 'wire', 'hairless', or 'curly'.}

\item{status}{Animal status to filter search results. Must be one of 'adoptable', 'adopted', or 'found'.}

\item{name}{Searches for animal names matching or partially matching name.}

\item{organization_id}{Returns animals associated with given :code:`organization_id`. Can be a vector or a vector 
or list of character strings representing multiple organizations.}

\item{location}{Returns results by specified location. Must be in the format 'city, state' for city-level results, 
'latitude, longitude' for lat-long results, or 'postal code'.}

\item{distance}{Returns results within the distance of the specified location. If not given, defaults to 100 miles. 
Maximum distance range is 500 miles.}

\item{sort}{Sorts by specified attribute. Leading dashes represents a reverse-order sort. Must be one of 
'recent', '-recent', 'distance', or '-distance'.}

\item{pages}{Specifies which page of results to return. Defaults to the first page of results. If set to 
NULL, all results will be returned.}

\item{results_per_page}{Number of results to return per page. Defaults to 20 results and cannot exceed 100 
results per page.}

\item{return_df}{If TRUE, a data.frame will be returned. Does not currently do anything.}
}
\value{
List of JSON data of resulting animals.
}
\description{
Returns adoptable animal data from Petfinder based on specified criteria.
}
\examples{
\dontrun{
pf <- Petfinder(key=key, secret=secret) # Initialize Petfinder class
pf$animals(results_per_page = 100, pages = 10)
pf$animals(location='Seattle, WA', distance = 100, results_per_page = 50, pages = 5)
pf$animals(animal_id=c(animalid1, animalid2, animalid3))
}
}
