% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addCohortIntersect.R
\name{addCohortIntersectDate}
\alias{addCohortIntersectDate}
\title{Date of cohorts that are present in a certain window}
\usage{
addCohortIntersectDate(
  x,
  targetCohortTable,
  targetCohortId = NULL,
  indexDate = "cohort_start_date",
  censorDate = NULL,
  targetDate = "cohort_start_date",
  order = "first",
  window = c(0, Inf),
  nameStyle = "{cohort_name}_{window_name}",
  name = NULL
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{targetCohortTable}{Cohort table to.}

\item{targetCohortId}{Cohort IDs of interest from the other cohort table. If
NULL, all cohorts will be used with a time variable added for each
cohort of interest.}

\item{indexDate}{Variable in x that contains the date to compute the
intersection.}

\item{censorDate}{whether to censor overlap events at a specific date
or a column date of x.}

\item{targetDate}{Date of interest in the other cohort table. Either
cohort_start_date or cohort_end_date.}

\item{order}{date to use if there are multiple records for an
individual during the window of interest. Either first or last.}

\item{window}{Window of time to identify records relative to the indexDate.
Records outside of this time period will be ignored.}

\item{nameStyle}{naming of the added column or columns, should include
required parameters.}

\item{name}{Name of the new table, if NULL a temporary table is returned.}
}
\value{
x along with additional columns for each cohort of interest.
}
\description{
Date of cohorts that are present in a certain window
}
\examples{
\donttest{
cdm <- mockPatientProfiles()

cdm$cohort1 \%>\%
  addCohortIntersectDate(
    targetCohortTable = "cohort2"
  )
mockDisconnect(cdm = cdm)
}

}
