% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseDemographics.R
\name{summariseDemographics}
\alias{summariseDemographics}
\title{Summarise demographics of individuals}
\usage{
summariseDemographics(cohort, strata = list(), ageGroup = NULL)
}
\arguments{
\item{cohort}{A cohort in the cdm.}

\item{strata}{Stratification list.}

\item{ageGroup}{A list of age groups.}
}
\value{
A summary of the demographics of the individuals.
}
\description{
Summarise demographics of individuals
}
\examples{
\donttest{
library(PatientProfiles)

cdm <- mockPatientProfiles()

summariseDemographics(
  cohort = cdm$cohort1,
  ageGroup = list(c(0, 19), c(20, 39), c(40, 59), c(60, 79), c(80, 150))
)
CDMConnector::cdmDisconnect(cdm = cdm)
}
}
