% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{rGenPareto}
\alias{rGenPareto}
\title{Simulation of the generalized Pareto Distribution}
\usage{
rGenPareto(n, t, alpha_ini, alpha_tail, truncation = NULL)
}
\arguments{
\item{n}{Numeric. Number of observations.}

\item{t}{Numeric vector. Thresholds of the generalized Pareto distributions}

\item{alpha_ini}{Numeric vector. Initial Pareto alphas of the generalized Pareto distributions.}

\item{alpha_tail}{Numeric vector. Tail Pareto alphas of the generalized Pareto distributions.}

\item{truncation}{NULL or Numeric vector. If \code{truncation} is not \code{NULL} and \code{truncation > t}, then the generalized Pareto distributions are truncated at \code{truncation} (resampled generalized Pareto)}
}
\value{
A vector of \code{n} samples from the (truncated) generalized Pareto distribution with parameters \code{t}, \code{alpha_ini} and \code{alpha_tail}
}
\description{
Generates random deviates of a generalized Pareto distribution
}
\examples{
rGenPareto(100, 1000, 2, 3)
rGenPareto(100, 1000, 2, 3, truncation = 2000)
rGenPareto(100, t = c(1, 10, 100, 1000), alpha_ini = 1, alpha_tail = c(2, 5))

}
