% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{Pareto_ML_Estimator_Alpha}
\alias{Pareto_ML_Estimator_Alpha}
\title{Maximum Likelihood Estimation of the Pareto Alpha}
\usage{
Pareto_ML_Estimator_Alpha(
  losses,
  t,
  truncation = NULL,
  alpha_min = 0.001,
  alpha_max = 10
)
}
\arguments{
\item{losses}{Numeric vector. Losses that are used for the ML estimation.}

\item{t}{Numeric. Threshold of the Pareto distribution.}

\item{truncation}{Numeric. If \code{truncation} is not \code{NULL} and \code{truncation > t}, then the Pareto distribution is truncated at \code{truncation}.}

\item{alpha_min}{Numeric. Lower bound for alpha.}

\item{alpha_max}{Numeric. Upper bound for alpha.}
}
\value{
Maximum likelihood estimator for the parameter \code{alpha} of a Pareto distribution with threshold \code{t} given the observations \code{losses}
}
\description{
Calculates the maximum likelihood estimator of the parameter alpha of a Pareto distribution
}
\examples{
losses <- rPareto(100, 1000, 2)
Pareto_ML_Estimator_Alpha(losses, 1000)
losses <- rPareto(100, 1000, 2, truncation = 2000)
Pareto_ML_Estimator_Alpha(losses, 1000)
Pareto_ML_Estimator_Alpha(losses, 1000, truncation = 2000)

}
