% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ParallelPC.R
\name{rfci_stable}
\alias{rfci_stable}
\title{Estimate a PAG using the RFCI_stable Algorithm}
\usage{
rfci_stable(suffStat, indepTest, alpha, labels, p, skel.method = c("stable",
  "original", "stable.fast"), fixedGaps = NULL, fixedEdges = NULL,
  NAdelete = TRUE, m.max = Inf, rules = rep(TRUE, 10),
  conservative = FALSE, maj.rule = FALSE, verbose = FALSE)
}
\arguments{
\item{suffStat}{Sufficient statistics: List containing all necessary elements for the conditional independence decisions in the function indepTest.}

\item{indepTest}{Predefined function for testing conditional independence. The function is internally called as indepTest(x,y,S,suffStat), and tests conditional independence of x and y given S. Here, x and y are variables, and S is a (possibly empty) vector of variables (all variables are denoted by their column numbers in the adjacency matrix). suffStat is a list containing all relevant elements for the conditional independence decisions. The return value of indepTest is the p-value of the test for conditional independence.}

\item{alpha}{significance level (number in (0,1) for the individual conditional independence tests.}

\item{labels}{(optional) character vector of variable (or "node") names. Typically preferred to specifying p.}

\item{p}{(optional) number of variables (or nodes). May be specified if labels are not, in which case labels is set to 1:p.}

\item{skel.method}{Character string specifying method; the default, "stable" provides an order-independent skeleton, see skeleton.}

\item{fixedGaps}{A logical matrix of dimension p*p. If entry [i,j] or [j,i] (or both) are TRUE, the edge i-j is removed before starting the algorithm. Therefore, this edge is guaranteed to be absent in the resulting graph.}

\item{fixedEdges}{A logical matrix of dimension p*p. If entry [i,j] or [j,i] (or both) are TRUE, the edge i-j is never considered for removal. Therefore, this edge is guaranteed to be present in the resulting graph.}

\item{NAdelete}{If indepTest returns NA and this option is TRUE, the corresponding edge is deleted. If this option is FALSE, the edge is not deleted.}

\item{m.max}{Maximum size of the conditioning sets that are considered in the conditional independence tests.}

\item{rules}{Logical vector of length 10 indicating which rules should be used when directing edges. See the pcalg package for details.}

\item{conservative}{Logical indicating if the unshielded triples should be checked for ambiguity after the skeleton has been found, similar to the conservative PC algorithm.}

\item{maj.rule}{Logical indicating if the unshielded triples should be checked for ambiguity after the skeleton has been found using a majority rule idea, which is less strict than the conservative.}

\item{verbose}{If true, more detailed output is provided.}
}
\value{
An object of class fciAlgo (see fciAlgo in the pcalg package) containing the estimated graph (in the form of an adjacency matrix with various possible edge marks), the conditioning sets that lead to edge removals (sepset) and several other parameters.
}
\description{
This is the RFCI stable version in the pcalg package.
}
\examples{
##########################################
## Using rfci_stable
##########################################
library(pcalg)
library(parallel)
data("gmG")
p<-ncol(gmG$x)
suffStat<-list(C=cor(gmG$x),n=nrow(gmG$x))
rfci_stable(suffStat, indepTest=gaussCItest, p=p, skel.method="stable", alpha=0.01)
}
\references{
1. Diego Colombo, Marloes H Maathuis, Markus Kalisch, Thomas S Richardson, et al. Learning high-dimensional directed acyclic graphs with latent and selection variables. The Annals of Statistics, 40(1):294-321, 2012.

2. Markus Kalisch, Martin Machler, Diego Colombo, Marloes H Maathuis, and Peter Buhlmann. Causal inference using graphical models with the r package pcalg.
 Journal of Statistical Software, 47(11):1-26, 2012.
}

