% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Logging.R
\name{logInfo}
\alias{logInfo}
\title{Log a message at the INFO level}
\usage{
logInfo(...)
}
\arguments{
\item{...}{Zero or more objects which can be coerced to character (and which are pasted together
with no separator).}
}
\description{
Log a message at the INFO level
}
\details{
Log a message at the specified level. The message will be sent to all the registered loggers. This
is equivalent to calling R's native \code{message()} function.
}
\examples{
appender <- createConsoleAppender(layout = layoutTimestamp)

logger <- createLogger(name = "SIMPLE",
                       threshold = "INFO",
                       appenders = list(appender))
registerLogger(logger)                      
logTrace("This event is below the threshold (INFO)")
logInfo("Hello world")                       
unregisterLogger("SIMPLE")                     
}
