% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Loggers.R
\name{addDefaultEmailLogger}
\alias{addDefaultEmailLogger}
\title{Add the default e-mail logger}
\usage{
addDefaultEmailLogger(
  mailSettings,
  label = Sys.info()["nodename"],
  name = "DEFAULT_EMAIL_LOGGER",
  test = FALSE
)
}
\arguments{
\item{mailSettings}{Arguments to be passed to the send.mail function in the mailR package (except
subject and body).}

\item{label}{A label to be used in the e-mail subject to identify a run. By default the
name of the computer is used.}

\item{name}{A name for the logger.}

\item{test}{If TRUE, a message will be displayed on the console instead of sending an
e-mail.}
}
\description{
Add the default e-mail logger
}
\details{
Creates a logger that writes to e-mail using the "FATAL" threshold and the
\code{\link{layoutEmail}} layout. This function uses the \code{mailR} package. Please make sure
your e-mail settings are correct by using the mailR package before using those settings here.
ParallelLogger will not display any messages if something goes wrong when sending the e-mail.
}
\examples{
mailSettings <- list(from = "someone@gmail.com",
                     to = c("someone_else@gmail.com"),
                     smtp = list(host.name = "smtp.gmail.com",
                                 port = 465,
                                 user.name = "someone@gmail.com",
                                 passwd = "super_secret!",
                                 ssl = TRUE),
                     authenticate = TRUE,
                     send = TRUE)

# Setting test to TRUE in this example so we don't really send an e-mail:
addDefaultEmailLogger(mailSettings, "My R session", test = TRUE)
logFatal("Something bad")

unregisterLogger("DEFAULT")

}
