% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Args.R
\name{createArgFunction}
\alias{createArgFunction}
\title{Create an argument function}
\usage{
createArgFunction(
  functionName,
  excludeArgs = c(),
  includeArgs = NULL,
  addArgs = list(),
  rCode = c(),
  newName
)
}
\arguments{
\item{functionName}{The name of the function for which we want to create an args function.}

\item{excludeArgs}{Exclude these arguments from appearing in the args function.}

\item{includeArgs}{Include these arguments in the args function.}

\item{addArgs}{Add these arguments to the args functions. Defined as a list with format name
= default.}

\item{rCode}{A character vector representing the R code where the new function should be
appended to.}

\item{newName}{The name of the new function. If not specified, the new name will be
automatically derived from the old name.}
}
\value{
A character vector with the R code including the new function.
}
\description{
Create an argument function
}
\details{
This function can be used to create a function that has (almost) the same interface as the
specified function, and the output of this function will be a list of argument values.
}
\examples{
createArgFunction("read.csv", addArgs = list(exposureId = "exposureId"))

}
