% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoissonRE.R
\name{PoissonRE}
\alias{PoissonRE}
\title{A Poisson Model with Random Effects}
\usage{
PoissonRE(
  formula,
  data,
  id.name,
  par = NULL,
  sigma = NULL,
  method = "BFGS",
  stopUpdate = FALSE,
  se_type = c("Hessian", "BHHH")[1],
  H = 20,
  reltol = sqrt(.Machine$double.eps),
  verbose = 0
)
}
\arguments{
\item{formula}{Formula of the model}

\item{data}{Input data, a data.frame object}

\item{id.name}{The name of the column representing id. Data will be sorted by id to improve estimation speed.}

\item{par}{Starting values for estimates. Default to estimates of Poisson Model}

\item{sigma}{Starting value for sigma. Defaults to 1 and will be ignored if par is provided.}

\item{method}{Optimization method used by optim. Defaults to 'BFGS'.}

\item{stopUpdate}{Whether to disable update of Adaptive Gaussian Quadrature parameters. Defaults to FALSE.}

\item{se_type}{Report Hessian or BHHH standard errors. Defaults to Hessian.}

\item{H}{Number of Quadrature points used for numerical integration using the Gaussian-Hermite Quadrature method. Defaults to 20.}

\item{reltol}{Relative convergence tolerance. The algorithm stops if it is unable to reduce the value by a factor of reltol * (abs(val) + reltol) at a step. Defaults to sqrt(.Machine$double.eps), typically about 1e-8.}

\item{verbose}{A integer indicating how much output to display during the estimation process.
\itemize{
\item <0 - No ouput
\item 0 - Basic output (model estimates)
\item 1 - Moderate output, basic ouput + parameter and likelihood in each iteration
\item 2 - Extensive output, moderate output + gradient values on each call
}}
}
\value{
A list containing the results of the estimated model, some of which are inherited from the return of optim
\itemize{
\item estimates: Model estimates with 95\% confidence intervals
\item par: Point estimates
\item var_bhhh: BHHH covariance matrix, inverse of the outer product of gradient at the maximum
\item var_hessian: Inverse of negative Hessian matrix (the second order derivative of likelihood at the maximum)
\item se_bhhh: BHHH standard errors
\item g: Gradient function at maximum
\item gtHg: \eqn{g'H^-1g}, where H^-1 is approximated by var_bhhh. A value close to zero (e.g., <1e-3 or 1e-6) indicates good convergence.
\item LL: Likelihood
\item AIC: AIC
\item BIC: BIC
\item n_obs: Number of observations
\item time: Time takes to estimate the model
\item partial: Average partial effect at the population level
\item paritalAvgObs: Partial effect for an individual with average characteristics
\item predict: A list with predicted participation probability (prob), predicted potential outcome (outcome), and predicted actual outcome (actual_outcome).
\item counts: From optim. A two-element integer vector giving the number of calls to fn and gr respectively. This excludes those calls needed to compute the Hessian, if requested, and any calls to fn to compute a finite-difference approximation to the gradient.
\item message: From optim. A character string giving any additional information returned by the optimizer, or NULL.
\item convergence: From optim. An integer code. 0 indicates successful completion.
Note that the list inherits all the complements in the output of optim. See the documentation of optim for more details.
}
}
\description{
Estimate a Poisson model with random effects at the individual level.
\deqn{E[y_{it}|x_{it},v_i] = exp(\boldsymbol{\beta}\mathbf{x_{it}}' + \sigma v_i)}{E[y_it | x_it,v_i] = exp(\beta*x_it' + \sigma*v_i)}
Notations:
\itemize{
\item \eqn{x_{it}}{x_it}: variables influencing the outcome \eqn{y_{it}}{y_it}, which could be a mixture of time-variant variables, time-invariant variables, and time dummies
\item \eqn{v_i}: individual level random effect
}
}
\examples{
# Use the simulated dataset, in which the true coefficient of x is 1.
# Estimated coefficient is biased primarily due to omission of self-selection
data(sim)
res = PoissonRE(y~x, data=sim[!is.na(sim$y), ], id.name='id', verbose=-1)
res$estimates
}
\references{
\enumerate{
\item Peng, J., & Van den Bulte, C. (2022). Participation vs. Effectiveness in Sponsored Tweet Campaigns: A Quality-Quantity Conundrum. Available at SSRN: https://ssrn.com/abstract=2702053
\item Peng, J., & Van Den Bulte, C. (2015). How to Better Target and Incent Paid Endorsers in Social Advertising Campaigns: A Field Experiment. 2015 International Conference on Information Systems. https://aisel.aisnet.org/icis2015/proceedings/SocialMedia/24
}
}
\seealso{
Other PanelCount: 
\code{\link{PLN_RE}()},
\code{\link{ProbitRE_PLNRE}()},
\code{\link{ProbitRE_PoissonRE}()},
\code{\link{ProbitRE}()}
}
\concept{PanelCount}
